/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.panels.SimpleTableDefPanel;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.SchemaFactory;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.Alignment;
import org.eobjects.datacleaner.widgets.tabs.CloseableTabbedPane;
import org.eobjects.datacleaner.widgets.tabs.TabCloseEvent;
import org.eobjects.datacleaner.widgets.tabs.TabCloseListener;
import org.eobjects.metamodel.schema.ColumnType;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.SimpleTableDef;

public class SimpleTableDefsPanel
extends DCPanel {
    private static final long serialVersionUID = 1L;
    private static final Icon TABLE_ICON = ImageManager.getInstance().getImageIcon("images/model/table.png", new ClassLoader[0]);
    private final CloseableTabbedPane _tabbedPane;
    private final SchemaFactory _schemaFactory;

    public SimpleTableDefsPanel() {
        this((SchemaFactory)null);
    }

    public SimpleTableDefsPanel(SchemaFactory schemaFactory) {
        this(schemaFactory, null);
    }

    public SimpleTableDefsPanel(SchemaFactory schemaFactory, SimpleTableDef[] tableDefs) {
        this._schemaFactory = schemaFactory;
        this._tabbedPane = new CloseableTabbedPane();
        this._tabbedPane.setVisible(false);
        if (tableDefs != null) {
            for (SimpleTableDef tableDef : tableDefs) {
                this.addTableDef(tableDef);
            }
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this._tabbedPane, "Center");
        this.add((Component)this.createButtonPanel(), "North");
        this.setMinimumSize(new Dimension(400, 300));
        this._tabbedPane.addTabCloseListener(new TabCloseListener(){

            @Override
            public void tabClosed(TabCloseEvent ev) {
                if (SimpleTableDefsPanel.this._tabbedPane.getTabCount() == 0) {
                    SimpleTableDefsPanel.this._tabbedPane.setVisible(false);
                }
            }
        });
    }

    private DCPanel createButtonPanel() {
        JButton addButton = WidgetFactory.createSmallButton("images/actions/add.png");
        addButton.setText("Add table");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tableName = JOptionPane.showInputDialog(SimpleTableDefsPanel.this, "What is the name of the table", "Add table", 3);
                if (!StringUtils.isNullOrEmpty((String)tableName)) {
                    SimpleTableDef tableDef = new SimpleTableDef(tableName, new String[0]);
                    SimpleTableDefsPanel.this.addTableDef(tableDef);
                }
            }
        });
        DCPanel buttonPanel = DCPanel.flow(Alignment.RIGHT, 10, 10, addButton);
        if (this._schemaFactory != null) {
            JButton autoDetectButton = WidgetFactory.createSmallButton("images/actions/refresh.png");
            autoDetectButton.setText("Auto-detect tables");
            autoDetectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Table[] tables;
                    SimpleTableDefsPanel.this.removeAllTableDefs();
                    Schema schema = SimpleTableDefsPanel.this._schemaFactory.createSchema();
                    for (Table table : tables = schema.getTables()) {
                        SimpleTableDefsPanel.this.addTableDef(SimpleTableDefsPanel.this.createTableDef(table));
                    }
                }
            });
            buttonPanel.add(autoDetectButton);
        }
        return buttonPanel;
    }

    private SimpleTableDef createTableDef(Table table) {
        int columnCount = table.getColumnCount();
        String[] names = new String[columnCount];
        ColumnType[] types = new ColumnType[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            names[i] = table.getColumn(i).getName();
            types[i] = table.getColumn(i).getType();
        }
        return new SimpleTableDef(table.getName(), names, types);
    }

    public void removeAllTableDefs() {
        while (this._tabbedPane.getTabCount() > 0) {
            this._tabbedPane.removeTabAt(this._tabbedPane.getTabCount() - 1);
        }
    }

    public void addTableDef(SimpleTableDef tableDef) {
        this._tabbedPane.addTab(tableDef.getName(), TABLE_ICON, new SimpleTableDefPanel(tableDef));
        this._tabbedPane.setVisible(true);
    }

    public SimpleTableDef[] getTableDefs() {
        int tabCount = this._tabbedPane.getTabCount();
        SimpleTableDef[] result = new SimpleTableDef[tabCount];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getTableDef(i);
        }
        return result;
    }

    private SimpleTableDef getTableDef(int index) {
        Component component = this._tabbedPane.getComponentAt(index);
        SimpleTableDefPanel panel = (SimpleTableDefPanel)component;
        return panel.getTableDef();
    }
}

