/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.border.EmptyBorder;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.MetaModelInputColumn;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.FilterJobBuilder;
import org.eobjects.analyzer.job.builder.SourceColumnChangeListener;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.ColumnListTable;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.panels.maxrows.MaxRowsFilterShortcutPanel;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.Table;
import org.jdesktop.swingx.VerticalLayout;

public final class SourceColumnsPanel
extends DCPanel
implements SourceColumnChangeListener {
    private static final long serialVersionUID = 1L;
    private final List<ColumnListTable> _sourceColumnTables = new ArrayList<ColumnListTable>();
    private final DCLabel _hintLabel;
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final MaxRowsFilterShortcutPanel _maxRowsFilterShortcutPanel;
    private final WindowContext _windowContext;

    @Inject
    protected SourceColumnsPanel(AnalysisJobBuilder analysisJobBuilder, WindowContext windowContext) {
        this._analysisJobBuilder = analysisJobBuilder;
        this._windowContext = windowContext;
        this._maxRowsFilterShortcutPanel = this.createMaxRowsFilterShortcutPanel();
        this._hintLabel = DCLabel.darkMultiLine("Please select the source columns of your job in the tree to the left.\n\nSource columns define where to retrieve the input of your analysis.");
        this._hintLabel.setFont(WidgetUtils.FONT_HEADER2);
        this._hintLabel.setBorder(new EmptyBorder(20, 20, 20, 20));
        this._hintLabel.setIconTextGap(20);
        this._hintLabel.setIcon(ImageManager.getInstance().getImageIcon("images/model/column.png", new ClassLoader[0]));
        this._analysisJobBuilder.getSourceColumnListeners().add(this);
        this.setBorder(WidgetUtils.BORDER_EMPTY);
        this.setLayout((LayoutManager)new VerticalLayout(4));
        this.add(this._maxRowsFilterShortcutPanel);
        this.add(this._hintLabel);
        this.add(Box.createVerticalStrut(10));
        List sourceColumns = analysisJobBuilder.getSourceColumns();
        for (MetaModelInputColumn column : sourceColumns) {
            this.onAdd((InputColumn<?>)column);
        }
    }

    private MaxRowsFilterShortcutPanel createMaxRowsFilterShortcutPanel() {
        MaxRowsFilterShortcutPanel maxRowsFilterShortcutPanel = null;
        List filterJobBuilders = this._analysisJobBuilder.getFilterJobBuilders();
        for (FilterJobBuilder filterJobBuilder : filterJobBuilders) {
            if (!MaxRowsFilterShortcutPanel.isFilter(filterJobBuilder)) continue;
            maxRowsFilterShortcutPanel = new MaxRowsFilterShortcutPanel(this._analysisJobBuilder, filterJobBuilder);
            break;
        }
        if (maxRowsFilterShortcutPanel == null) {
            maxRowsFilterShortcutPanel = new MaxRowsFilterShortcutPanel(this._analysisJobBuilder);
        }
        maxRowsFilterShortcutPanel.setEnabled(false);
        return maxRowsFilterShortcutPanel;
    }

    public void onAdd(InputColumn<?> sourceColumn) {
        this._hintLabel.setVisible(false);
        this._maxRowsFilterShortcutPanel.setEnabled(true);
        Column column = sourceColumn.getPhysicalColumn();
        Table table = column.getTable();
        ColumnListTable sourceColumnTable = this.getColumnListTable(table);
        sourceColumnTable.addColumn(sourceColumn);
    }

    public void onRemove(InputColumn<?> sourceColumn) {
        Column column = sourceColumn.getPhysicalColumn();
        Table table = column.getTable();
        ColumnListTable sourceColumnTable = this.getColumnListTable(table);
        sourceColumnTable.removeColumn(sourceColumn);
        if (sourceColumnTable.getColumnCount() == 0) {
            this.remove(sourceColumnTable);
            this._sourceColumnTables.remove(sourceColumnTable);
            if (this._analysisJobBuilder.getSourceColumns().isEmpty()) {
                this._hintLabel.setVisible(true);
                this._maxRowsFilterShortcutPanel.setEnabled(false);
            }
            this.updateUI();
        }
    }

    private ColumnListTable getColumnListTable(Table table) {
        ColumnListTable sourceColumnTable = null;
        for (ColumnListTable sct : this._sourceColumnTables) {
            if (sct.getTable() != table) continue;
            sourceColumnTable = sct;
            break;
        }
        if (sourceColumnTable == null) {
            sourceColumnTable = new ColumnListTable(table, this._analysisJobBuilder, true, this._windowContext);
            this.add(sourceColumnTable);
            this._sourceColumnTables.add(sourceColumnTable);
            this.updateUI();
        }
        return sourceColumnTable;
    }

    @Override
    public void removeNotify() {
        this._analysisJobBuilder.getSourceColumnListeners().remove(this);
        super.removeNotify();
    }

    public MaxRowsFilterShortcutPanel getMaxRowsFilterShortcutPanel() {
        return this._maxRowsFilterShortcutPanel;
    }
}

