/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.reference.RegexStringPattern;
import org.eobjects.analyzer.reference.SimpleStringPattern;
import org.eobjects.analyzer.reference.StringPattern;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCGlassPane;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.regexswap.RegexSwapDialog;
import org.eobjects.datacleaner.regexswap.RegexSwapStringPattern;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.user.StringPatternChangeListener;
import org.eobjects.datacleaner.util.HttpXmlUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.DCPopupBubble;
import org.eobjects.datacleaner.widgets.HelpIcon;
import org.eobjects.datacleaner.windows.RegexStringPatternDialog;
import org.eobjects.datacleaner.windows.SimpleStringPatternDialog;
import org.jdesktop.swingx.VerticalLayout;

public class StringPatternListPanel
extends DCPanel
implements StringPatternChangeListener {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final AnalyzerBeansConfiguration _configuration;
    private final MutableReferenceDataCatalog _catalog;
    private final DCPanel _listPanel;
    private final DCGlassPane _glassPane;
    private final WindowContext _windowContext;
    private final HttpXmlUtils _httpXmlUtils;

    @Inject
    protected StringPatternListPanel(DCGlassPane glassPane, AnalyzerBeansConfiguration configuration, WindowContext windowContext, HttpXmlUtils httpXmlUtils) {
        super(WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_BRIGHTEST);
        this._glassPane = glassPane;
        this._configuration = configuration;
        this._windowContext = windowContext;
        this._httpXmlUtils = httpXmlUtils;
        this._catalog = (MutableReferenceDataCatalog)this._configuration.getReferenceDataCatalog();
        this._catalog.addStringPatternListener(this);
        this._listPanel = new DCPanel();
        this._listPanel.setLayout((LayoutManager)new VerticalLayout(4));
        this.updateComponents();
        DCLabel newStringPatternsLabel = DCLabel.dark("Create new string pattern:");
        newStringPatternsLabel.setFont(WidgetUtils.FONT_HEADER1);
        DCLabel existingStringPatternsLabel = DCLabel.dark("Existing string patterns:");
        existingStringPatternsLabel.setFont(WidgetUtils.FONT_HEADER1);
        this.setLayout((LayoutManager)new VerticalLayout(10));
        this.add(newStringPatternsLabel);
        this.add(this.createNewStringPatternsPanel());
        this.add(Box.createVerticalStrut(10));
        this.add(existingStringPatternsLabel);
        this.setBorder(new EmptyBorder(10, 10, 10, 0));
        this.add(this._listPanel);
    }

    private DCPanel createNewStringPatternsPanel() {
        JButton simpleStringPatternButton = this.createButton("images/model/stringpattern_simple.png", "<html><b>Simple string pattern</b><br/>A string pattern based on simple string tokens, eg. 'Aaaaa 999'.</html>");
        simpleStringPatternButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SimpleStringPatternDialog(StringPatternListPanel.this._catalog, StringPatternListPanel.this._windowContext).setVisible(true);
            }
        });
        JButton regexStringPatternButton = this.createButton("images/model/stringpattern_regex.png", "<html><b>Regular expression string pattern</b><br/>A very flexible string pattern, based on regular expressions.</html>");
        regexStringPatternButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new RegexStringPatternDialog(StringPatternListPanel.this._catalog, StringPatternListPanel.this._windowContext).setVisible(true);
            }
        });
        JButton regexSwapStringPatternButton = this.createButton("images/model/stringpattern_regexswap.png", "<html><b>Browse the RegexSwap</b><br/>Download patterns from DataCleaner's online RegexSwap.</html>");
        regexSwapStringPatternButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new RegexSwapDialog(StringPatternListPanel.this._catalog, StringPatternListPanel.this._windowContext, StringPatternListPanel.this._httpXmlUtils).setVisible(true);
            }
        });
        HelpIcon helpIcon = new HelpIcon("<b>String patterns</b><br>String pattern provides a way to match string values against patterns. This is often useful for validation or categorization of values in semi- or unstructured columns.");
        DCPanel panel = DCPanel.flow(simpleStringPatternButton, regexStringPatternButton, regexSwapStringPatternButton, Box.createHorizontalStrut(100), helpIcon);
        panel.setBorder(WidgetUtils.BORDER_LIST_ITEM);
        return panel;
    }

    private JButton createButton(String imagePath, String description) {
        JButton button = WidgetFactory.createImageButton(imageManager.getImageIcon(imagePath, new ClassLoader[0]));
        DCPopupBubble popupBubble = new DCPopupBubble(this._glassPane, description, 0, 0, imagePath);
        popupBubble.attachTo(button);
        return button;
    }

    private void updateComponents() {
        this._listPanel.removeAll();
        Object[] names = this._catalog.getStringPatternNames();
        Arrays.sort(names);
        ImageIcon icon = imageManager.getImageIcon("images/model/stringpattern.png", new ClassLoader[0]);
        for (Object name : names) {
            final StringPattern stringPattern = this._catalog.getStringPattern((String)name);
            DCLabel stringPatternLabel = DCLabel.dark("<html><b>" + (String)name + "</b><br/>" + StringPatternListPanel.getDescription(stringPattern) + "</html>");
            stringPatternLabel.setIcon(icon);
            stringPatternLabel.setMaximumWidth(280);
            JButton editButton = WidgetFactory.createSmallButton("images/actions/edit.png");
            editButton.setToolTipText("Edit string pattern");
            if (stringPattern instanceof RegexStringPattern) {
                editButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RegexStringPatternDialog dialog = new RegexStringPatternDialog((RegexStringPattern)stringPattern, StringPatternListPanel.this._catalog, StringPatternListPanel.this._windowContext);
                        dialog.setVisible(true);
                    }
                });
            } else if (stringPattern instanceof SimpleStringPattern) {
                editButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SimpleStringPatternDialog dialog = new SimpleStringPatternDialog((SimpleStringPattern)stringPattern, StringPatternListPanel.this._catalog, StringPatternListPanel.this._windowContext);
                        dialog.setVisible(true);
                    }
                });
            } else {
                editButton.setEnabled(false);
            }
            JButton removeButton = WidgetFactory.createSmallButton("images/actions/remove.png");
            removeButton.setToolTipText("Remove string pattern");
            removeButton.addActionListener(new ActionListener((String)name, stringPattern){
                final /* synthetic */ String val$name;
                final /* synthetic */ StringPattern val$stringPattern;
                {
                    this.val$name = string;
                    this.val$stringPattern = stringPattern;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result = JOptionPane.showConfirmDialog(StringPatternListPanel.this, "Are you sure you wish to remove the string pattern '" + this.val$name + "'?", "Confirm remove", 0);
                    if (result == 0) {
                        StringPatternListPanel.this._catalog.removeStringPattern(this.val$stringPattern);
                    }
                }
            });
            if (!this._catalog.isStringPatternMutable((String)name)) {
                editButton.setEnabled(false);
                removeButton.setEnabled(false);
            }
            DCPanel stringPatternPanel = new DCPanel();
            stringPatternPanel.setBorder(WidgetUtils.BORDER_LIST_ITEM);
            WidgetUtils.addToGridBag((Component)stringPatternLabel, (JPanel)stringPatternPanel, 0, 0, 1.0, 0.0);
            WidgetUtils.addToGridBag(editButton, stringPatternPanel, 1, 0, 13);
            WidgetUtils.addToGridBag(removeButton, stringPatternPanel, 2, 0, 13);
            this._listPanel.add(stringPatternPanel);
        }
        if (names.length == 0) {
            this._listPanel.add(DCLabel.dark("(none)"));
        }
        this.updateUI();
    }

    private static String getDescription(StringPattern stringPattern) {
        if (stringPattern.getDescription() != null) {
            return stringPattern.getDescription();
        }
        String description = stringPattern instanceof RegexSwapStringPattern ? ((RegexSwapStringPattern)stringPattern).getRegex().getExpression() : (stringPattern instanceof RegexStringPattern ? ((RegexStringPattern)stringPattern).getExpression() : (stringPattern instanceof SimpleStringPattern ? ((SimpleStringPattern)stringPattern).getExpression() : ""));
        if (description == null) {
            return "";
        }
        if (description.length() > 30) {
            return description.substring(0, 27) + "...";
        }
        return description;
    }

    @Override
    public void onAdd(StringPattern stringPattern) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StringPatternListPanel.this.updateComponents();
            }
        });
    }

    @Override
    public void onRemove(StringPattern stringPattern) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StringPatternListPanel.this.updateComponents();
            }
        });
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._catalog.removeStringPatternListener(this);
    }
}

