/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import com.google.inject.Injector;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.reference.DatastoreSynonymCatalog;
import org.eobjects.analyzer.reference.SynonymCatalog;
import org.eobjects.analyzer.reference.TextFileSynonymCatalog;
import org.eobjects.datacleaner.guice.InjectorBuilder;
import org.eobjects.datacleaner.panels.DCGlassPane;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.user.SynonymCatalogChangeListener;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.DCPopupBubble;
import org.eobjects.datacleaner.widgets.HelpIcon;
import org.eobjects.datacleaner.windows.DatastoreSynonymCatalogDialog;
import org.eobjects.datacleaner.windows.TextFileSynonymCatalogDialog;
import org.jdesktop.swingx.VerticalLayout;

public final class SynonymCatalogListPanel
extends DCPanel
implements SynonymCatalogChangeListener {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final AnalyzerBeansConfiguration _configuration;
    private final MutableReferenceDataCatalog _catalog;
    private final DCPanel _listPanel;
    private final DCGlassPane _glassPane;
    private final InjectorBuilder _injectorBuilder;

    @Inject
    protected SynonymCatalogListPanel(DCGlassPane glassPane, AnalyzerBeansConfiguration configuration, InjectorBuilder injectorBuilder) {
        super(WidgetUtils.BG_COLOR_BRIGHT, WidgetUtils.BG_COLOR_BRIGHTEST);
        this._glassPane = glassPane;
        this._configuration = configuration;
        this._injectorBuilder = injectorBuilder;
        this._catalog = (MutableReferenceDataCatalog)this._configuration.getReferenceDataCatalog();
        this._catalog.addSynonymCatalogListener(this);
        this._listPanel = new DCPanel();
        this._listPanel.setLayout((LayoutManager)new VerticalLayout(4));
        this.updateComponents();
        DCLabel newSynonymCatalogsLabel = DCLabel.dark("Create new synonym catalog:");
        newSynonymCatalogsLabel.setFont(WidgetUtils.FONT_HEADER1);
        DCLabel existingSynonymCatalogsLabel = DCLabel.dark("Existing synonym catalogs:");
        existingSynonymCatalogsLabel.setFont(WidgetUtils.FONT_HEADER1);
        this.setLayout((LayoutManager)new VerticalLayout(10));
        this.add(newSynonymCatalogsLabel);
        this.add(this.createNewSynonymCatalogsPanel());
        this.add(Box.createVerticalStrut(10));
        this.add(existingSynonymCatalogsLabel);
        this.setBorder(new EmptyBorder(10, 10, 10, 0));
        this.add(this._listPanel);
    }

    private DCPanel createNewSynonymCatalogsPanel() {
        JButton textFileSynonymCatalogButton = this.createButton("images/model/synonym_textfile.png", "<html><b>Text file synonym catalog</b><br/>Synonyms from a file with master terms and comma-separated synonyms.</html>");
        textFileSynonymCatalogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Injector injector = SynonymCatalogListPanel.this._injectorBuilder.with(TextFileSynonymCatalog.class, null).createInjector();
                TextFileSynonymCatalogDialog dialog = (TextFileSynonymCatalogDialog)injector.getInstance(TextFileSynonymCatalogDialog.class);
                dialog.setVisible(true);
            }
        });
        JButton datastoreSynonymCatalogButton = this.createButton("images/model/synonym_datastore.png", "<html><b>Datastore synonym catalog</b><br/>Synonym catalog based on columns in a registered datastore.</html>");
        datastoreSynonymCatalogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Injector injector = SynonymCatalogListPanel.this._injectorBuilder.with(DatastoreSynonymCatalog.class, null).createInjector();
                DatastoreSynonymCatalogDialog dialog = (DatastoreSynonymCatalogDialog)injector.getInstance(DatastoreSynonymCatalogDialog.class);
                dialog.setVisible(true);
            }
        });
        HelpIcon helpIcon = new HelpIcon("<b>Synonym catalogs</b><br>A synonym catalog is reference data used for replacing odd values with correct ones. A synonym in this sense can also be eg. a standardized value or a code for a given entity.<br>Synonyms can be used throughout DataCleaner for matching, replacing values and more..");
        DCPanel panel = DCPanel.flow(textFileSynonymCatalogButton, datastoreSynonymCatalogButton, Box.createHorizontalStrut(100), helpIcon);
        panel.setBorder(WidgetUtils.BORDER_LIST_ITEM);
        return panel;
    }

    private JButton createButton(String imagePath, String description) {
        JButton button = WidgetFactory.createImageButton(imageManager.getImageIcon(imagePath, new ClassLoader[0]));
        DCPopupBubble popupBubble = new DCPopupBubble(this._glassPane, description, 0, 0, imagePath);
        popupBubble.attachTo(button);
        return button;
    }

    private void updateComponents() {
        this._listPanel.removeAll();
        Object[] names = this._catalog.getSynonymCatalogNames();
        Arrays.sort(names);
        ImageIcon icon = imageManager.getImageIcon("images/model/synonym.png", new ClassLoader[0]);
        for (Object name : names) {
            final SynonymCatalog synonymCatalog = this._catalog.getSynonymCatalog((String)name);
            DCLabel synonymCatalogLabel = DCLabel.dark("<html><b>" + (String)name + "</b><br/>" + SynonymCatalogListPanel.getDescription(synonymCatalog) + "</html>");
            synonymCatalogLabel.setIcon(icon);
            synonymCatalogLabel.setMaximumWidth(280);
            JButton editButton = WidgetFactory.createSmallButton("images/actions/edit.png");
            editButton.setToolTipText("Edit synonym catalog");
            if (synonymCatalog instanceof TextFileSynonymCatalog) {
                editButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Injector injector = SynonymCatalogListPanel.this._injectorBuilder.with(TextFileSynonymCatalog.class, (Object)synonymCatalog).createInjector();
                        TextFileSynonymCatalogDialog dialog = (TextFileSynonymCatalogDialog)injector.getInstance(TextFileSynonymCatalogDialog.class);
                        dialog.setVisible(true);
                    }
                });
            } else if (synonymCatalog instanceof DatastoreSynonymCatalog) {
                editButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Injector injector = SynonymCatalogListPanel.this._injectorBuilder.with(DatastoreSynonymCatalog.class, (Object)synonymCatalog).createInjector();
                        DatastoreSynonymCatalogDialog dialog = (DatastoreSynonymCatalogDialog)injector.getInstance(DatastoreSynonymCatalogDialog.class);
                        dialog.setVisible(true);
                    }
                });
            } else {
                editButton.setEnabled(false);
            }
            JButton removeButton = WidgetFactory.createSmallButton("images/actions/remove.png");
            removeButton.setToolTipText("Remove synonym catalog");
            removeButton.addActionListener(new ActionListener((String)name, synonymCatalog){
                final /* synthetic */ String val$name;
                final /* synthetic */ SynonymCatalog val$synonymCatalog;
                {
                    this.val$name = string;
                    this.val$synonymCatalog = synonymCatalog;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    int result = JOptionPane.showConfirmDialog(SynonymCatalogListPanel.this, "Are you sure you wish to remove the synonym catalog '" + this.val$name + "'?", "Confirm remove", 0);
                    if (result == 0) {
                        SynonymCatalogListPanel.this._catalog.removeSynonymCatalog(this.val$synonymCatalog);
                    }
                }
            });
            if (!this._catalog.isSynonymCatalogMutable((String)name)) {
                editButton.setEnabled(false);
                removeButton.setEnabled(false);
            }
            DCPanel synonymCatalogPanel = new DCPanel();
            synonymCatalogPanel.setBorder(WidgetUtils.BORDER_LIST_ITEM);
            WidgetUtils.addToGridBag((Component)synonymCatalogLabel, (JPanel)synonymCatalogPanel, 0, 0, 1.0, 0.0);
            WidgetUtils.addToGridBag(editButton, synonymCatalogPanel, 1, 0, 13);
            WidgetUtils.addToGridBag(removeButton, synonymCatalogPanel, 2, 0, 13);
            this._listPanel.add(synonymCatalogPanel);
        }
        if (names.length == 0) {
            this._listPanel.add(DCLabel.dark("(none)"));
        }
        this.updateUI();
    }

    private static String getDescription(SynonymCatalog synonymCatalog) {
        if (synonymCatalog.getDescription() != null) {
            return synonymCatalog.getDescription();
        }
        if (synonymCatalog instanceof TextFileSynonymCatalog) {
            return ((TextFileSynonymCatalog)synonymCatalog).getFilename();
        }
        if (synonymCatalog instanceof DatastoreSynonymCatalog) {
            DatastoreSynonymCatalog datastoreSynonymCatalog = (DatastoreSynonymCatalog)synonymCatalog;
            return datastoreSynonymCatalog.getDatastoreName() + ": " + datastoreSynonymCatalog.getMasterTermColumnPath();
        }
        return "";
    }

    @Override
    public void onAdd(SynonymCatalog synonymCatalog) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SynonymCatalogListPanel.this.updateComponents();
            }
        });
    }

    @Override
    public void onRemove(SynonymCatalog synonymCatalog) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SynonymCatalogListPanel.this.updateComponents();
            }
        });
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._catalog.removeSynonymCatalogListener(this);
    }
}

