/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.MutableInputColumn;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.TransformerJobBuilder;
import org.eobjects.datacleaner.actions.DisplayOutputWritersForTransformedDataActionListener;
import org.eobjects.datacleaner.actions.PreviewTransformedDataActionListener;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.AbstractJobBuilderPanel;
import org.eobjects.datacleaner.panels.ColumnListTable;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.panels.TransformerJobBuilderPresenter;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.widgets.properties.PropertyWidgetFactory;

public class TransformerJobBuilderPanel
extends AbstractJobBuilderPanel
implements TransformerJobBuilderPresenter {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private static final Image WATERMARK_IMAGE = imageManager.getImage("images/window/transformer-tab-background.png", new ClassLoader[0]);
    private final TransformerJobBuilder<?> _transformerJobBuilder;
    private final ColumnListTable _outputColumnsTable;
    private final JButton _previewButton;
    private final JButton _writeDataButton;
    private final WindowContext _windowContext;

    public TransformerJobBuilderPanel(TransformerJobBuilder<?> transformerJobBuilder, WindowContext windowContext, PropertyWidgetFactory propertyWidgetFactory, AnalyzerBeansConfiguration configuration) {
        this(WATERMARK_IMAGE, 95, 95, transformerJobBuilder, windowContext, propertyWidgetFactory, configuration);
    }

    protected TransformerJobBuilderPanel(Image watermarkImage, int watermarkHorizontalPosition, int watermarkVerticalPosition, TransformerJobBuilder<?> transformerJobBuilder, WindowContext windowContext, PropertyWidgetFactory propertyWidgetFactory, AnalyzerBeansConfiguration configuration) {
        super(watermarkImage, watermarkHorizontalPosition, watermarkVerticalPosition, (AbstractBeanJobBuilder<?, ?, ?>)transformerJobBuilder, propertyWidgetFactory);
        this._transformerJobBuilder = transformerJobBuilder;
        this._windowContext = windowContext;
        ArrayList outputColumns = this._transformerJobBuilder.isConfigured() ? this._transformerJobBuilder.getOutputColumns() : new ArrayList(0);
        this._outputColumnsTable = new ColumnListTable(outputColumns, this.getAnalysisJobBuilder(), false, this._windowContext);
        this._writeDataButton = new JButton("Write data", imageManager.getImageIcon("images/component-types/type_output_writer.png", new ClassLoader[0]));
        this._writeDataButton.addActionListener(new DisplayOutputWritersForTransformedDataActionListener(this._transformerJobBuilder));
        this._previewButton = new JButton("Preview data", imageManager.getImageIcon("images/actions/preview_data.png", new ClassLoader[0]));
        this._previewButton.addActionListener(new PreviewTransformedDataActionListener(this._windowContext, this, this.getAnalysisJobBuilder(), this._transformerJobBuilder, configuration));
        DCPanel bottomButtonPanel = new DCPanel();
        bottomButtonPanel.setLayout(new FlowLayout(2, 4, 0));
        bottomButtonPanel.add(this._writeDataButton);
        bottomButtonPanel.add(this._previewButton);
        this._outputColumnsTable.add((Component)bottomButtonPanel, "South");
    }

    public WindowContext getWindowContext() {
        return this._windowContext;
    }

    @Override
    protected JComponent decorate(DCPanel panel) {
        JComponent result = super.decorate(panel);
        this.addTaskPane(imageManager.getImageIcon("images/model/source.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]), "Output columns", this._outputColumnsTable);
        return result;
    }

    public void setOutputColumns(List<? extends InputColumn<?>> outputColumns) {
        this._outputColumnsTable.setColumns(outputColumns);
    }

    @Override
    public TransformerJobBuilder<?> getJobBuilder() {
        return this._transformerJobBuilder;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.getAnalysisJobBuilder().getTransformerChangeListeners().remove(this);
    }

    @Override
    public void onOutputChanged(List<MutableInputColumn<?>> outputColumns) {
        this._outputColumnsTable.setColumns(outputColumns);
    }
}

