/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels.datastructures;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.properties.MinimalPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.MultipleStringPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleClassPropertyWidget;
import org.eobjects.metamodel.util.EqualsBuilder;
import org.jdesktop.swingx.JXTextField;

public class KeysAndTypesPropertyWidget
extends MultipleStringPropertyWidget {
    private final ConfiguredPropertyDescriptor _typesProperty;
    private final List<DCComboBox<Class<?>>> _comboBoxes = new ArrayList();
    private final MinimalPropertyWidget<Class[]> _typesPropertyWidget;

    public KeysAndTypesPropertyWidget(ConfiguredPropertyDescriptor keysProperty, ConfiguredPropertyDescriptor typesProperty, AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder) {
        super(keysProperty, beanJobBuilder);
        this._typesProperty = typesProperty;
        this._typesPropertyWidget = new MinimalPropertyWidget<Class[]>(this.getBeanJobBuilder(), this._typesProperty){

            @Override
            public JComponent getWidget() {
                return null;
            }

            @Override
            public Class[] getValue() {
                String[] keys = KeysAndTypesPropertyWidget.this.getValue();
                ArrayList result = new ArrayList();
                for (int i = 0; i < keys.length; ++i) {
                    if (StringUtils.isNullOrEmpty((String)keys[i])) continue;
                    DCComboBox comboBox = (DCComboBox)KeysAndTypesPropertyWidget.this._comboBoxes.get(i);
                    result.add(comboBox.getSelectedItem());
                }
                return result.toArray(new Class[result.size()]);
            }

            @Override
            public boolean isSet() {
                if (KeysAndTypesPropertyWidget.this._comboBoxes.isEmpty()) {
                    return false;
                }
                for (DCComboBox comboBox : KeysAndTypesPropertyWidget.this._comboBoxes) {
                    if (comboBox.getSelectedItem() != null) continue;
                    return false;
                }
                return true;
            }

            @Override
            protected void setValue(Class[] value) {
                String[] keys;
                if (EqualsBuilder.equals((Object)value, (Object)this.getValue())) {
                    return;
                }
                if (value == null) {
                    value = new Class[]{};
                }
                if ((keys = KeysAndTypesPropertyWidget.this.getValue()).length != value.length) {
                    return;
                }
                for (int i = 0; i < keys.length; ++i) {
                    DCComboBox comboBox = (DCComboBox)KeysAndTypesPropertyWidget.this._comboBoxes.get(i);
                    Class selectedClass = value[i];
                    comboBox.setSelectedItem(selectedClass);
                }
            }
        };
        String[] currentKeysValue = (String[])this.getCurrentValue();
        Class[] currentTypesValue = (Class[])beanJobBuilder.getConfiguredProperty(typesProperty);
        if (currentTypesValue != null) {
            for (int i = 0; i < currentTypesValue.length; ++i) {
                Class type = currentTypesValue[i];
                this.createComboBox(type);
            }
            this.setValue(currentKeysValue);
            this._typesPropertyWidget.onValueTouched(currentTypesValue);
        }
    }

    private DCComboBox<Class<?>> createComboBox(Class<?> type) {
        DCComboBox<Class<?>> comboBox = SingleClassPropertyWidget.createClassComboBox(true);
        if (type != null) {
            comboBox.setSelectedItem(type);
        }
        this._comboBoxes.add(comboBox);
        return comboBox;
    }

    @Override
    protected JComponent decorateTextField(JXTextField textField, int index) {
        DCComboBox<Class<?>> comboBox = index < this._comboBoxes.size() ? this._comboBoxes.get(index) : this.createComboBox(null);
        comboBox.addListener(new DCComboBox.Listener<Class<?>>(){

            @Override
            public void onItemSelected(Class<?> item) {
                KeysAndTypesPropertyWidget.this._typesPropertyWidget.fireValueChanged();
            }
        });
        textField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        KeysAndTypesPropertyWidget.this.setUpdating(true);
                        KeysAndTypesPropertyWidget.this._typesPropertyWidget.fireValueChanged();
                        KeysAndTypesPropertyWidget.this.setUpdating(false);
                    }
                });
            }
        });
        DCPanel panel = new DCPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)textField, "Center");
        panel.add(comboBox, "East");
        return panel;
    }

    public PropertyWidget<?> getTypesPropertyWidget() {
        return this._typesPropertyWidget;
    }

    @Override
    protected boolean isEmptyStringValid() {
        return false;
    }
}

