/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels.insertintotable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eobjects.analyzer.beans.writers.InsertIntoTableAnalyzer;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.descriptors.AnalyzerBeanDescriptor;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.AnalyzerJobBuilder;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.AnalyzerJobBuilderPanel;
import org.eobjects.datacleaner.panels.ConfiguredPropertyTaskPane;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.properties.MultipleMappedPrefixedColumnsPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidgetFactory;
import org.eobjects.datacleaner.widgets.properties.SchemaNamePropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleDatastorePropertyWidget;
import org.eobjects.datacleaner.widgets.properties.TableNamePropertyWidget;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;

class InsertIntoTableJobBuilderPresenter
extends AnalyzerJobBuilderPanel {
    private static final long serialVersionUID = 1L;
    private final Map<ConfiguredPropertyDescriptor, PropertyWidget<?>> _overriddenPropertyWidgets = new HashMap();
    private final ConfiguredPropertyDescriptor _schemaNameProperty;
    private final ConfiguredPropertyDescriptor _tableNameProperty;
    private final ConfiguredPropertyDescriptor _datastoreProperty;
    private final ConfiguredPropertyDescriptor _inputColumnsProperty;
    private final ConfiguredPropertyDescriptor _columnNamesProperty;
    private final ConfiguredPropertyDescriptor _errorHandlingProperty;
    private final ConfiguredPropertyDescriptor _errorFileLocationProperty;
    private final ConfiguredPropertyDescriptor _additionalErrorLogValuesProperty;
    private final ConfiguredPropertyDescriptor _bufferSizeProperty;
    private final ConfiguredPropertyDescriptor _truncateTableProperty;

    public InsertIntoTableJobBuilderPresenter(AnalyzerJobBuilder<InsertIntoTableAnalyzer> analyzerJobBuilder, WindowContext windowContext, PropertyWidgetFactory propertyWidgetFactory, AnalyzerBeansConfiguration configuration) {
        super(analyzerJobBuilder, propertyWidgetFactory);
        AnalyzerBeanDescriptor descriptor = (AnalyzerBeanDescriptor)analyzerJobBuilder.getDescriptor();
        assert (descriptor.getComponentClass() == InsertIntoTableAnalyzer.class);
        this._datastoreProperty = descriptor.getConfiguredProperty("Datastore");
        this._schemaNameProperty = descriptor.getConfiguredProperty("Schema name");
        this._tableNameProperty = descriptor.getConfiguredProperty("Table name");
        this._inputColumnsProperty = descriptor.getConfiguredProperty("Values");
        this._columnNamesProperty = descriptor.getConfiguredProperty("Column names");
        this._bufferSizeProperty = descriptor.getConfiguredProperty("Buffer size");
        this._truncateTableProperty = descriptor.getConfiguredProperty("Truncate table");
        this._errorHandlingProperty = descriptor.getConfiguredProperty("How to handle insertion errors?");
        this._errorFileLocationProperty = descriptor.getConfiguredProperty("Error log file location");
        this._additionalErrorLogValuesProperty = descriptor.getConfiguredProperty("Additional error log values");
        assert (this._datastoreProperty != null);
        assert (this._datastoreProperty.getType() == Datastore.class);
        SingleDatastorePropertyWidget datastorePropertyWidget = new SingleDatastorePropertyWidget((AbstractBeanJobBuilder<?, ?, ?>)analyzerJobBuilder, this._datastoreProperty, configuration.getDatastoreCatalog());
        this._overriddenPropertyWidgets.put(this._datastoreProperty, datastorePropertyWidget);
        final SchemaNamePropertyWidget schemaNamePropertyWidget = new SchemaNamePropertyWidget((AbstractBeanJobBuilder<?, ?, ?>)analyzerJobBuilder, this._schemaNameProperty);
        this._overriddenPropertyWidgets.put(this._schemaNameProperty, schemaNamePropertyWidget);
        final TableNamePropertyWidget tableNamePropertyWidget = new TableNamePropertyWidget((AbstractBeanJobBuilder<?, ?, ?>)analyzerJobBuilder, this._tableNameProperty);
        this._overriddenPropertyWidgets.put(this._tableNameProperty, tableNamePropertyWidget);
        assert (this._inputColumnsProperty != null);
        assert (this._inputColumnsProperty.getType() == InputColumn[].class);
        final MultipleMappedPrefixedColumnsPropertyWidget inputColumnsPropertyWidget = new MultipleMappedPrefixedColumnsPropertyWidget((AbstractBeanJobBuilder<?, ?, ?>)analyzerJobBuilder, this._inputColumnsProperty, this._columnNamesProperty, " -> ");
        this._overriddenPropertyWidgets.put(this._inputColumnsProperty, inputColumnsPropertyWidget);
        assert (this._columnNamesProperty != null);
        assert (this._columnNamesProperty.getType() == String[].class);
        this._overriddenPropertyWidgets.put(this._columnNamesProperty, inputColumnsPropertyWidget.getMappedColumnNamesPropertyWidget());
        datastorePropertyWidget.addComboListener(new DCComboBox.Listener<Datastore>(){

            @Override
            public void onItemSelected(Datastore item) {
                schemaNamePropertyWidget.setDatastore(item);
            }
        });
        schemaNamePropertyWidget.addComboListener(new DCComboBox.Listener<Schema>(){

            @Override
            public void onItemSelected(Schema item) {
                tableNamePropertyWidget.setSchema(item);
            }
        });
        tableNamePropertyWidget.addComboListener(new DCComboBox.Listener<Table>(){

            @Override
            public void onItemSelected(Table item) {
                inputColumnsPropertyWidget.setTable(item);
            }
        });
        schemaNamePropertyWidget.setDatastore(datastorePropertyWidget.getValue());
        tableNamePropertyWidget.setSchema(schemaNamePropertyWidget.getSchema());
        inputColumnsPropertyWidget.setTable(tableNamePropertyWidget.getTable());
    }

    @Override
    protected List<ConfiguredPropertyTaskPane> createPropertyTaskPanes() {
        ConfiguredPropertyTaskPane taskPane = new ConfiguredPropertyTaskPane("Insert mapping", "images/model/column.png", Arrays.asList(this._datastoreProperty, this._schemaNameProperty, this._tableNameProperty, this._inputColumnsProperty, this._truncateTableProperty, this._bufferSizeProperty));
        ConfiguredPropertyTaskPane errorHandlingPane = new ConfiguredPropertyTaskPane("Error handling", "images/status/warning.png", Arrays.asList(this._errorHandlingProperty, this._errorFileLocationProperty, this._additionalErrorLogValuesProperty), false);
        ArrayList<ConfiguredPropertyTaskPane> propertyTaskPanes = new ArrayList<ConfiguredPropertyTaskPane>();
        propertyTaskPanes.add(taskPane);
        propertyTaskPanes.add(errorHandlingPane);
        return propertyTaskPanes;
    }

    @Override
    protected PropertyWidget<?> createPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        if (this._overriddenPropertyWidgets.containsKey(propertyDescriptor)) {
            return this._overriddenPropertyWidgets.get(propertyDescriptor);
        }
        return super.createPropertyWidget(beanJobBuilder, propertyDescriptor);
    }
}

