/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels.maxrows;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import org.eobjects.analyzer.beans.filter.MaxRowsFilter;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.analyzer.job.builder.FilterJobBuilder;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.NumberDocument;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCCheckBox;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.jdesktop.swingx.JXTextField;

public class MaxRowsFilterShortcutPanel
extends DCPanel {
    private static final long serialVersionUID = 1L;
    public static final String MAX_ROWS_PROPERTY_NAME = "Max rows";
    public static final String FILTER_NAME = "Limit analysis (Max rows)";
    private static final String DEFAULT_MAX_ROWS = "1000";
    private final AnalysisJobBuilder _analysisJobBuilder;
    private final JXTextField _textField;
    private final DCCheckBox<Object> _checkBox;
    private final DCLabel _suffixLabel;
    private final DCLabel _prefixLabel;
    private FilterJobBuilder<MaxRowsFilter, MaxRowsFilter.Category> _maxRowsFilterJobBuilder;

    public static boolean isFilter(FilterJobBuilder<?, ?> filterJobBuilder) {
        return FILTER_NAME.equals(filterJobBuilder.getName()) && ((FilterBeanDescriptor)filterJobBuilder.getDescriptor()).getComponentClass() == MaxRowsFilter.class;
    }

    public MaxRowsFilterShortcutPanel(AnalysisJobBuilder analysisJobBuilder) {
        this(analysisJobBuilder, null);
    }

    public MaxRowsFilterShortcutPanel(AnalysisJobBuilder analysisJobBuilder, FilterJobBuilder<?, ?> filterJobBuilder) {
        this._analysisJobBuilder = analysisJobBuilder;
        this._checkBox = new DCCheckBox("", false);
        this._textField = WidgetFactory.createTextField();
        this._textField.setEnabled(false);
        this._textField.setColumns(4);
        this._textField.setDocument((Document)new NumberDocument());
        if (filterJobBuilder != null) {
            ConfiguredPropertyDescriptor propertyDescriptor = ((FilterBeanDescriptor)filterJobBuilder.getDescriptor()).getConfiguredProperty(MAX_ROWS_PROPERTY_NAME);
            Object value = filterJobBuilder.getConfiguredProperty(propertyDescriptor);
            if (value != null) {
                this._textField.setText(value.toString());
            } else {
                this._textField.setText(DEFAULT_MAX_ROWS);
            }
        } else {
            this._textField.setText(DEFAULT_MAX_ROWS);
        }
        this._prefixLabel = DCLabel.dark("Limit analysis to max ");
        this._prefixLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MaxRowsFilterShortcutPanel.this._checkBox.doClick();
            }
        });
        this._prefixLabel.setEnabled(false);
        this._suffixLabel = DCLabel.dark(" rows.");
        this._suffixLabel.setEnabled(false);
        if (filterJobBuilder != null) {
            FilterJobBuilder<?, ?> maxRowFilterJobBuilder = filterJobBuilder;
            this._maxRowsFilterJobBuilder = maxRowFilterJobBuilder;
            this._checkBox.setSelected(true);
        }
        this._checkBox.addListener(new DCCheckBox.Listener<Object>(){

            @Override
            public void onItemSelected(Object item, boolean selected) {
                FilterJobBuilder<MaxRowsFilter, MaxRowsFilter.Category> maxRowsFilterJobBuilder = MaxRowsFilterShortcutPanel.this.getJobBuilder();
                if (selected) {
                    MaxRowsFilterShortcutPanel.this._analysisJobBuilder.addFilter(maxRowsFilterJobBuilder);
                    MaxRowsFilterShortcutPanel.this._analysisJobBuilder.setDefaultRequirement(maxRowsFilterJobBuilder, (Enum)MaxRowsFilter.Category.VALID);
                } else {
                    MaxRowsFilterShortcutPanel.this._analysisJobBuilder.removeFilter(maxRowsFilterJobBuilder);
                    MaxRowsFilterShortcutPanel.this._maxRowsFilterJobBuilder = null;
                }
                MaxRowsFilterShortcutPanel.this.updateLabels();
            }
        });
        this._textField.getDocument().addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent event) {
                String text;
                FilterJobBuilder<MaxRowsFilter, MaxRowsFilter.Category> fjb = MaxRowsFilterShortcutPanel.this.getJobBuilder();
                if (fjb != null && !StringUtils.isNullOrEmpty((String)(text = MaxRowsFilterShortcutPanel.this._textField.getText()))) {
                    try {
                        int maxRows = Integer.parseInt(text);
                        fjb.setConfiguredProperty(MaxRowsFilterShortcutPanel.MAX_ROWS_PROPERTY_NAME, (Object)maxRows);
                    }
                    catch (NumberFormatException e) {
                        WidgetUtils.showErrorMessage("Cannot read number", "The entered value could not be read as a number.", e);
                    }
                }
            }
        });
        this.setLayout(new FlowLayout(0));
        String imagePath = IconUtils.getImagePathForClass(MaxRowsFilter.class);
        this.add(new JLabel(ImageManager.getInstance().getImageIcon(imagePath, new ClassLoader[0])));
        this.add(this._checkBox);
        this.add(this._prefixLabel);
        this.add((Component)this._textField);
        this.add(this._suffixLabel);
        this.updateLabels();
        this.setBorder(WidgetUtils.BORDER_LIST_ITEM);
    }

    public FilterJobBuilder<MaxRowsFilter, MaxRowsFilter.Category> getJobBuilder() {
        if (this._maxRowsFilterJobBuilder == null) {
            this._maxRowsFilterJobBuilder = new FilterJobBuilder(this._analysisJobBuilder, this._analysisJobBuilder.getConfiguration().getDescriptorProvider().getFilterBeanDescriptorForClass(MaxRowsFilter.class));
            this._maxRowsFilterJobBuilder.setName(FILTER_NAME);
        }
        return this._maxRowsFilterJobBuilder;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._checkBox.setEnabled(enabled);
    }

    public void setFilterEnabled(boolean enabled) {
        if (enabled != this.isFilterEnabled()) {
            this._checkBox.doClick();
        }
    }

    public boolean isFilterEnabled() {
        return this._checkBox.isSelected();
    }

    private void updateLabels() {
        boolean selected = this._checkBox.isSelected();
        this._prefixLabel.setEnabled(selected);
        this._textField.setEnabled(selected);
        this._suffixLabel.setEnabled(selected);
    }

    public void resetToDefault() {
        this._checkBox.setSelected(false);
        this._textField.setText(DEFAULT_MAX_ROWS);
    }
}

