/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels.tablelookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eobjects.analyzer.beans.transform.TableLookupTransformer;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.descriptors.TransformerBeanDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.TransformerJobBuilder;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.ConfiguredPropertyTaskPane;
import org.eobjects.datacleaner.panels.TransformerJobBuilderPanel;
import org.eobjects.datacleaner.panels.tablelookup.TableLookupOutputColumnsPropertyWidget;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.properties.MultipleMappedColumnsPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidgetFactory;
import org.eobjects.datacleaner.widgets.properties.SchemaNamePropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleDatastorePropertyWidget;
import org.eobjects.datacleaner.widgets.properties.TableNamePropertyWidget;
import org.eobjects.metamodel.schema.Schema;
import org.eobjects.metamodel.schema.Table;

class TableLookupJobBuilderPresenter
extends TransformerJobBuilderPanel {
    private static final long serialVersionUID = 1L;
    private final Map<ConfiguredPropertyDescriptor, PropertyWidget<?>> _overriddenPropertyWidgets = new HashMap();
    private final ConfiguredPropertyDescriptor _schemaNameProperty;
    private final ConfiguredPropertyDescriptor _tableNameProperty;
    private final ConfiguredPropertyDescriptor _datastoreProperty;
    private final ConfiguredPropertyDescriptor _inputColumnArrayProperty;
    private final ConfiguredPropertyDescriptor _columnNameArrayProperty;
    private final ConfiguredPropertyDescriptor _outputColumnsProperty;
    private final ConfiguredPropertyDescriptor _cacheLookupsProperty;

    public TableLookupJobBuilderPresenter(TransformerJobBuilder<TableLookupTransformer> transformerJobBuilder, WindowContext windowContext, PropertyWidgetFactory propertyWidgetFactory, AnalyzerBeansConfiguration configuration) {
        super(transformerJobBuilder, windowContext, propertyWidgetFactory, configuration);
        TransformerBeanDescriptor descriptor = (TransformerBeanDescriptor)transformerJobBuilder.getDescriptor();
        assert (descriptor.getComponentClass() == TableLookupTransformer.class);
        this._datastoreProperty = descriptor.getConfiguredProperty("Datastore");
        this._schemaNameProperty = descriptor.getConfiguredProperty("Schema name");
        this._tableNameProperty = descriptor.getConfiguredProperty("Table name");
        this._inputColumnArrayProperty = descriptor.getConfiguredProperty("Condition values");
        this._columnNameArrayProperty = descriptor.getConfiguredProperty("Condition columns");
        this._outputColumnsProperty = descriptor.getConfiguredProperty("Output columns");
        this._cacheLookupsProperty = descriptor.getConfiguredProperty("Cache lookups");
        assert (this._datastoreProperty != null);
        assert (this._datastoreProperty.getType() == Datastore.class);
        SingleDatastorePropertyWidget datastorePropertyWidget = new SingleDatastorePropertyWidget((AbstractBeanJobBuilder<?, ?, ?>)transformerJobBuilder, this._datastoreProperty, configuration.getDatastoreCatalog());
        this._overriddenPropertyWidgets.put(this._datastoreProperty, datastorePropertyWidget);
        final SchemaNamePropertyWidget schemaNamePropertyWidget = new SchemaNamePropertyWidget((AbstractBeanJobBuilder<?, ?, ?>)transformerJobBuilder, this._schemaNameProperty);
        this._overriddenPropertyWidgets.put(this._schemaNameProperty, schemaNamePropertyWidget);
        final TableNamePropertyWidget tableNamePropertyWidget = new TableNamePropertyWidget((AbstractBeanJobBuilder<?, ?, ?>)transformerJobBuilder, this._tableNameProperty);
        this._overriddenPropertyWidgets.put(this._tableNameProperty, tableNamePropertyWidget);
        final TableLookupOutputColumnsPropertyWidget outputColumnsPropertyWidget = new TableLookupOutputColumnsPropertyWidget((AbstractBeanJobBuilder<?, ?, ?>)transformerJobBuilder, this._outputColumnsProperty);
        this._overriddenPropertyWidgets.put(this._outputColumnsProperty, outputColumnsPropertyWidget);
        assert (this._inputColumnArrayProperty != null);
        assert (this._inputColumnArrayProperty.getType() == InputColumn[].class);
        final MultipleMappedColumnsPropertyWidget inputColumnsPropertyWidget = new MultipleMappedColumnsPropertyWidget((AbstractBeanJobBuilder<?, ?, ?>)transformerJobBuilder, this._inputColumnArrayProperty, this._columnNameArrayProperty);
        this._overriddenPropertyWidgets.put(this._inputColumnArrayProperty, inputColumnsPropertyWidget);
        assert (this._columnNameArrayProperty != null);
        assert (this._columnNameArrayProperty.getType() == String[].class);
        this._overriddenPropertyWidgets.put(this._columnNameArrayProperty, inputColumnsPropertyWidget.getMappedColumnNamesPropertyWidget());
        datastorePropertyWidget.addComboListener(new DCComboBox.Listener<Datastore>(){

            @Override
            public void onItemSelected(Datastore item) {
                schemaNamePropertyWidget.setDatastore(item);
            }
        });
        schemaNamePropertyWidget.addComboListener(new DCComboBox.Listener<Schema>(){

            @Override
            public void onItemSelected(Schema item) {
                tableNamePropertyWidget.setSchema(item);
            }
        });
        tableNamePropertyWidget.addComboListener(new DCComboBox.Listener<Table>(){

            @Override
            public void onItemSelected(Table item) {
                inputColumnsPropertyWidget.setTable(item);
                outputColumnsPropertyWidget.setTable(item);
            }
        });
        schemaNamePropertyWidget.setDatastore(datastorePropertyWidget.getValue());
        tableNamePropertyWidget.setSchema(schemaNamePropertyWidget.getSchema());
        outputColumnsPropertyWidget.setTable(tableNamePropertyWidget.getTable());
        inputColumnsPropertyWidget.setTable(tableNamePropertyWidget.getTable());
    }

    @Override
    protected List<ConfiguredPropertyTaskPane> createPropertyTaskPanes() {
        ArrayList<ConfiguredPropertyTaskPane> propertyTaskPanes = new ArrayList<ConfiguredPropertyTaskPane>();
        ConfiguredPropertyTaskPane inputMappingTaskPane = new ConfiguredPropertyTaskPane("Input mapping", "images/model/column.png", Arrays.asList(this._datastoreProperty, this._schemaNameProperty, this._tableNameProperty, this._inputColumnArrayProperty, this._cacheLookupsProperty));
        ConfiguredPropertyTaskPane outputMappingTaskPane = new ConfiguredPropertyTaskPane("Output mapping", "images/menu/options.png", Arrays.asList(this._outputColumnsProperty));
        propertyTaskPanes.add(inputMappingTaskPane);
        propertyTaskPanes.add(outputMappingTaskPane);
        return propertyTaskPanes;
    }

    @Override
    protected PropertyWidget<?> createPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        if (this._overriddenPropertyWidgets.containsKey(propertyDescriptor)) {
            return this._overriddenPropertyWidgets.get(propertyDescriptor);
        }
        return super.createPropertyWidget(beanJobBuilder, propertyDescriptor);
    }
}

