/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels.tablelookup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.SourceColumnComboBox;
import org.eobjects.datacleaner.widgets.properties.AbstractPropertyWidget;
import org.eobjects.metamodel.schema.Column;
import org.eobjects.metamodel.schema.MutableColumn;
import org.eobjects.metamodel.schema.Table;
import org.eobjects.metamodel.util.EqualsBuilder;
import org.eobjects.metamodel.util.MutableRef;
import org.jdesktop.swingx.VerticalLayout;

public class TableLookupOutputColumnsPropertyWidget
extends AbstractPropertyWidget<String[]> {
    private final List<SourceColumnComboBox> _comboBoxes = new ArrayList<SourceColumnComboBox>();
    private final MutableRef<Table> _tableRef = new MutableRef();
    private final DCPanel _comboBoxPanel = new DCPanel();

    public TableLookupOutputColumnsPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        super(beanJobBuilder, propertyDescriptor);
        this._comboBoxPanel.setLayout((LayoutManager)new VerticalLayout(2));
        JButton addButton = WidgetFactory.createSmallButton("images/actions/add.png");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableLookupOutputColumnsPropertyWidget.this.addComboBox(null, true);
                TableLookupOutputColumnsPropertyWidget.this.fireValueChanged();
            }
        });
        JButton removeButton = WidgetFactory.createSmallButton("images/actions/remove.png");
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int componentCount = TableLookupOutputColumnsPropertyWidget.this._comboBoxPanel.getComponentCount();
                if (componentCount > 0) {
                    TableLookupOutputColumnsPropertyWidget.this.removeComboBox();
                    TableLookupOutputColumnsPropertyWidget.this._comboBoxPanel.updateUI();
                    TableLookupOutputColumnsPropertyWidget.this.fireValueChanged();
                }
            }
        });
        DCPanel buttonPanel = new DCPanel();
        buttonPanel.setBorder(new EmptyBorder(0, 4, 0, 0));
        buttonPanel.setLayout((LayoutManager)new VerticalLayout(2));
        buttonPanel.add(addButton);
        buttonPanel.add(removeButton);
        DCPanel outerPanel = new DCPanel();
        outerPanel.setLayout(new BorderLayout());
        outerPanel.add((Component)this._comboBoxPanel, "Center");
        outerPanel.add((Component)buttonPanel, "East");
        this.add(outerPanel);
        String[] currentValue = (String[])this.getCurrentValue();
        this.setValue(currentValue);
    }

    protected void addComboBox(String value, boolean updateUI) {
        SourceColumnComboBox comboBox = new SourceColumnComboBox();
        Table table = (Table)this._tableRef.get();
        Object column = value == null ? null : (table == null ? new MutableColumn(value) : table.getColumnByName(value));
        comboBox.setModel(table);
        comboBox.setEditable(true);
        comboBox.setSelectedItem(column);
        comboBox.setEditable(false);
        comboBox.addListener(new DCComboBox.Listener<Column>(){

            @Override
            public void onItemSelected(Column item) {
                TableLookupOutputColumnsPropertyWidget.this.fireValueChanged();
            }
        });
        this._comboBoxes.add(comboBox);
        this._comboBoxPanel.add(comboBox);
        if (updateUI) {
            this._comboBoxPanel.updateUI();
        }
    }

    public void setTable(Table table) {
        this._tableRef.set((Object)table);
        for (SourceColumnComboBox comboBox : this._comboBoxes) {
            comboBox.setModel(table);
        }
    }

    @Override
    public String[] getValue() {
        ArrayList<String> result = new ArrayList<String>();
        for (SourceColumnComboBox comboBox : this._comboBoxes) {
            Column column = comboBox.getSelectedItem();
            if (column == null) continue;
            result.add(column.getName());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    protected void setValue(String[] values) {
        String[] previousValues;
        if (values == null || values.length == 0) {
            values = new String[1];
        }
        if (!EqualsBuilder.equals((Object)values, (Object)(previousValues = this.getValue()))) {
            for (int i = 0; i < Math.min(previousValues.length, values.length); ++i) {
                if (EqualsBuilder.equals((Object)previousValues[i], (Object)values[i])) continue;
                SourceColumnComboBox comboBox = this._comboBoxes.get(i);
                comboBox.setEditable(true);
                comboBox.setSelectedItem(values[i]);
                comboBox.setEditable(false);
            }
            while (this._comboBoxes.size() < values.length) {
                String nextValue = values[this._comboBoxes.size()];
                this.addComboBox(nextValue, false);
            }
            while (this._comboBoxes.size() > values.length) {
                this.removeComboBox();
            }
            this._comboBoxPanel.updateUI();
        }
    }

    private void removeComboBox() {
        int comboBoxIndex = this._comboBoxes.size() - 1;
        this._comboBoxes.remove(comboBoxIndex);
        this._comboBoxPanel.remove(comboBoxIndex);
    }
}

