/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.panels.tokenizer;

import org.eobjects.analyzer.beans.transform.TokenizerTransformer;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.descriptors.ConfiguredPropertyDescriptor;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.TransformerJobBuilder;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.TransformerJobBuilderPanel;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.eobjects.datacleaner.widgets.properties.PropertyWidget;
import org.eobjects.datacleaner.widgets.properties.PropertyWidgetFactory;
import org.eobjects.datacleaner.widgets.properties.SingleEnumPropertyWidget;
import org.eobjects.datacleaner.widgets.properties.SingleNumberPropertyWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TokenizerJobBuilderPresenter
extends TransformerJobBuilderPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(TokenizerJobBuilderPresenter.class);
    private SingleNumberPropertyWidget _numTokensPropertyWidget;
    private SingleEnumPropertyWidget _tokenTargetPropertyWidget;

    public TokenizerJobBuilderPresenter(TransformerJobBuilder<?> transformerJobBuilder, WindowContext windowContext, PropertyWidgetFactory propertyWidgetFactory, AnalyzerBeansConfiguration configuration) {
        super(transformerJobBuilder, windowContext, propertyWidgetFactory, configuration);
    }

    @Override
    protected PropertyWidget<?> createPropertyWidget(AbstractBeanJobBuilder<?, ?, ?> beanJobBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        PropertyWidget<?> propertyWidget = super.createPropertyWidget(beanJobBuilder, propertyDescriptor);
        String propertyName = propertyDescriptor.getName();
        if ("Token target".equals(propertyName)) {
            this._tokenTargetPropertyWidget = (SingleEnumPropertyWidget)propertyWidget;
            this._tokenTargetPropertyWidget.addComboListener(new DCComboBox.Listener<Enum<?>>(){

                @Override
                public void onItemSelected(Enum<?> item) {
                    if (item == TokenizerTransformer.TokenTarget.ROWS) {
                        if (TokenizerJobBuilderPresenter.this._numTokensPropertyWidget == null) {
                            logger.warn("No property widget for 'num tokens' found!");
                        } else if (!TokenizerJobBuilderPresenter.this._numTokensPropertyWidget.isSet()) {
                            TokenizerJobBuilderPresenter.this._numTokensPropertyWidget.onValueTouched(10000);
                        }
                    }
                }
            });
        } else if ("Number of tokens".equals(propertyName)) {
            this._numTokensPropertyWidget = (SingleNumberPropertyWidget)propertyWidget;
        }
        return propertyWidget;
    }
}

