/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.regexswap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.eobjects.datacleaner.regexswap.Category;
import org.eobjects.datacleaner.regexswap.Regex;
import org.eobjects.datacleaner.util.HttpXmlUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class RegexSwapClient {
    public static final String CATEGORIES_URL = "http://datacleaner.org/ws/categories";
    public static final String REGEXES_URL = "http://datacleaner.org/ws/regexes";
    private final Map<String, Category> _categories = new HashMap<String, Category>();
    private final Map<String, Regex> _regexes = new HashMap<String, Regex>();
    private final HttpClient _httpClient;

    public RegexSwapClient(HttpClient httpClient) {
        this._httpClient = httpClient;
    }

    public Category getCategoryByName(String name) {
        Category category = this._categories.get(name);
        if (category == null) {
            this.refreshCategories();
            category = this._categories.get(name);
        }
        return category;
    }

    public Regex getRegexByName(String name) {
        Regex regex = this._regexes.get(name);
        if (regex == null) {
            this.refreshRegexes();
            regex = this._regexes.get(name);
        }
        return regex;
    }

    public void refreshRegexes() {
        Element rootNode = HttpXmlUtils.getRootNode(this._httpClient, REGEXES_URL);
        List<Node> regexNodes = HttpXmlUtils.getChildNodesByName(rootNode, "regex");
        for (Node node : regexNodes) {
            this.createRegex((Element)node);
        }
    }

    public Collection<Category> getCategories() {
        if (this._categories.isEmpty()) {
            this.refreshCategories();
        }
        return this._categories.values();
    }

    public void refreshCategories() {
        Element rootNode = HttpXmlUtils.getRootNode(this._httpClient, CATEGORIES_URL);
        List<Node> categoryNodes = HttpXmlUtils.getChildNodesByName(rootNode, "category");
        for (Node categoryNode : categoryNodes) {
            String name = HttpXmlUtils.getChildNodeText(categoryNode, "name");
            String description = HttpXmlUtils.getChildNodeText(categoryNode, "description");
            String detailsUrl = HttpXmlUtils.getChildNodeText(categoryNode, "detailsUrl");
            Category category = new Category(name, description, detailsUrl);
            this._categories.put(name, category);
        }
    }

    private Regex createRegex(Element regexNode) {
        String name = HttpXmlUtils.getChildNodeText(regexNode, "name");
        String description = HttpXmlUtils.getChildNodeText(regexNode, "description");
        String expression = HttpXmlUtils.getChildNodeText(regexNode, "expression");
        String author = HttpXmlUtils.getChildNodeText(regexNode, "author");
        long timestamp = Long.parseLong(HttpXmlUtils.getChildNodeText(regexNode, "timestamp"));
        int positiveVotes = Integer.parseInt(HttpXmlUtils.getChildNodeText(regexNode, "positiveVotes"));
        int negativeVotes = Integer.parseInt(HttpXmlUtils.getChildNodeText(regexNode, "negativeVotes"));
        String detailsUrl = HttpXmlUtils.getChildNodeText(regexNode, "detailsUrl");
        ArrayList<Category> categories = new ArrayList<Category>();
        List<Node> categoriesNodes = HttpXmlUtils.getChildNodesByName(regexNode, "categories");
        if (!categoriesNodes.isEmpty()) {
            Node categoriesNode = categoriesNodes.get(0);
            List<Node> categoryNodes = HttpXmlUtils.getChildNodesByName(categoriesNode, "category");
            for (Node categoryNode : categoryNodes) {
                String categoryName = HttpXmlUtils.getText(categoryNode);
                Category category = this.getCategoryByName(categoryName);
                if (category == null) continue;
                categories.add(category);
            }
        }
        Regex regex = new Regex(name, description, expression, author, timestamp, positiveVotes, negativeVotes, detailsUrl, categories);
        this._regexes.put(name, regex);
        return regex;
    }

    public Regex refreshRegex(Regex regex) {
        String detailsUrl = regex.getDetailsUrl();
        Element regexNode = HttpXmlUtils.getRootNode(this._httpClient, detailsUrl);
        regex = this.createRegex(regexNode);
        return regex;
    }

    public List<Regex> getRegexes(Category category) {
        ArrayList<Regex> regexes = new ArrayList<Regex>();
        Element rootNode = HttpXmlUtils.getRootNode(this._httpClient, category.getDetailsUrl());
        List<Node> regexNodes = HttpXmlUtils.getChildNodesByName(rootNode, "regex");
        for (Node regexNode : regexNodes) {
            List<Category> categories;
            String name = HttpXmlUtils.getChildNodeText(regexNode, "name");
            String description = HttpXmlUtils.getChildNodeText(regexNode, "description");
            String expression = HttpXmlUtils.getChildNodeText(regexNode, "expression");
            String author = HttpXmlUtils.getChildNodeText(regexNode, "author");
            long timestamp = Long.parseLong(HttpXmlUtils.getChildNodeText(regexNode, "timestamp"));
            int positiveVotes = Integer.parseInt(HttpXmlUtils.getChildNodeText(regexNode, "positiveVotes"));
            int negativeVotes = Integer.parseInt(HttpXmlUtils.getChildNodeText(regexNode, "negativeVotes"));
            String detailsUrl = HttpXmlUtils.getChildNodeText(regexNode, "detailsUrl");
            Regex regex = this._regexes.get(name);
            if (regex == null) {
                categories = new ArrayList<Category>();
                regex = new Regex(name, description, expression, author, timestamp, positiveVotes, negativeVotes, detailsUrl, categories);
            } else {
                categories = regex.getCategories();
                if (!categories.contains(category)) {
                    categories.add(category);
                }
            }
            this._regexes.put(name, regex);
            regexes.add(regex);
        }
        return regexes;
    }
}

