/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.regexswap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.regexswap.Category;
import org.eobjects.datacleaner.regexswap.Regex;
import org.eobjects.datacleaner.regexswap.RegexSwapClient;
import org.eobjects.datacleaner.regexswap.RegexSwapStringPattern;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.util.HttpXmlUtils;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.CollapsibleTreePanel;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.table.DCTable;
import org.eobjects.datacleaner.windows.AbstractDialog;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.action.OpenBrowserAction;
import org.jdesktop.swingx.renderer.DefaultTreeRenderer;
import org.jdesktop.swingx.renderer.WrappingIconPanel;
import org.joda.time.DateTime;

public class RegexSwapDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private static final Object[] TABLE_HEADERS = new Object[]{"Name", "Good/bad votes", "Author"};
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final RegexSwapClient _client;
    private final JXTree _categoryTree;
    private final DCTable _regexSelectionTable;
    private final DCLabel _regexDescriptionLabel;
    private final JButton _importRegexButton;
    private final JButton _viewOnlineButton;
    private final TreeCellRenderer _treeRendererDelegate;
    private final MutableReferenceDataCatalog _referenceDataCatalog;
    private Regex _selectedRegex;

    public RegexSwapDialog(MutableReferenceDataCatalog referenceDataCatalog, WindowContext windowContext, HttpXmlUtils httpXmlUtils) {
        super(windowContext, imageManager.getImage("images/window/banner-string-patterns.png", new ClassLoader[0]));
        this._referenceDataCatalog = referenceDataCatalog;
        this._client = new RegexSwapClient(httpXmlUtils.getHttpClient());
        this._regexDescriptionLabel = DCLabel.brightMultiLine("No regex selected");
        this._importRegexButton = new JButton("Import regex", imageManager.getImageIcon("images/model/stringpattern_regexswap.png", new ClassLoader[0]));
        this._importRegexButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegexSwapStringPattern stringPattern = new RegexSwapStringPattern(RegexSwapDialog.this._selectedRegex);
                if (RegexSwapDialog.this._referenceDataCatalog.containsStringPattern(stringPattern.getName())) {
                    JOptionPane.showMessageDialog(RegexSwapDialog.this, "You already have a string pattern with the name '" + stringPattern.getName() + "'.");
                } else {
                    RegexSwapDialog.this._referenceDataCatalog.addStringPattern(stringPattern);
                    RegexSwapDialog.this.dispose();
                }
            }
        });
        this._importRegexButton.setEnabled(false);
        this._importRegexButton.setOpaque(false);
        this._importRegexButton.setFocusPainted(false);
        this._importRegexButton.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        this._viewOnlineButton = new JButton("View online", imageManager.getImageIcon("images/actions/website.png", new ClassLoader[0]));
        this._viewOnlineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OpenBrowserAction actionListener = new OpenBrowserAction(RegexSwapDialog.this._selectedRegex.createWebsiteUrl());
                actionListener.actionPerformed(event);
            }
        });
        this._viewOnlineButton.setEnabled(false);
        this._viewOnlineButton.setOpaque(false);
        this._viewOnlineButton.setFocusPainted(false);
        this._viewOnlineButton.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        this._regexSelectionTable = new DCTable();
        this._regexSelectionTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = RegexSwapDialog.this._regexSelectionTable.getSelectedRow();
                if (selectedRow >= 0) {
                    String regexName = (String)RegexSwapDialog.this._regexSelectionTable.getValueAt(selectedRow, 0);
                    Regex regex = RegexSwapDialog.this._client.getRegexByName(regexName);
                    RegexSwapDialog.this.onRegexSelected(regex);
                } else {
                    RegexSwapDialog.this.onRegexSelected(null);
                }
            }
        });
        this._regexSelectionTable.setModel(new DefaultTableModel(TABLE_HEADERS, 0));
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Loading categories ...");
        rootNode.add(new DefaultMutableTreeNode("Downloading from RegexSwap"));
        this._treeRendererDelegate = new DefaultTreeRenderer();
        this._categoryTree = new JXTree((TreeNode)rootNode);
        this._categoryTree.setOpaque(false);
        this._categoryTree.setCellRenderer(new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JComponent result;
                ImageIcon icon = null;
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (userObject instanceof Category) {
                    Category category = (Category)userObject;
                    result = (JComponent)RegexSwapDialog.this._treeRendererDelegate.getTreeCellRendererComponent(tree, category.getName(), selected, expanded, leaf, row, hasFocus);
                    result.setToolTipText(category.getDescription());
                    icon = imageManager.getImageIcon("images/filetypes/search-folder.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
                } else if (userObject instanceof JLabel) {
                    result = (JLabel)userObject;
                } else {
                    result = (JComponent)RegexSwapDialog.this._treeRendererDelegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                    if ("Categories".equals(userObject)) {
                        icon = imageManager.getImageIcon("images/filetypes/folder.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
                    }
                }
                boolean opaque = hasFocus || selected;
                result.setOpaque(opaque);
                if (result instanceof WrappingIconPanel) {
                    WrappingIconPanel wip = (WrappingIconPanel)result;
                    wip.getComponent().setOpaque(opaque);
                    if (icon != null) {
                        wip.setIcon((Icon)icon);
                    }
                }
                return result;
            }
        });
        this._categoryTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = RegexSwapDialog.this._categoryTree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    DefaultMutableTreeNode node;
                    Object userObject;
                    TreePath path = RegexSwapDialog.this._categoryTree.getPathForLocation(e.getX(), e.getY());
                    RegexSwapDialog.this._categoryTree.setSelectionPath(path);
                    RegexSwapDialog.this._categoryTree.updateUI();
                    if (path.getPathCount() == 2 && (userObject = (node = (DefaultMutableTreeNode)path.getPathComponent(1)).getUserObject()) instanceof Category) {
                        Category category = (Category)userObject;
                        RegexSwapDialog.this.fireCategorySelected(category);
                    }
                }
            }
        });
    }

    @Override
    protected JComponent getDialogContent() {
        JPanel regexDetailsPanel = this.createRegexDetailsPanel();
        DCPanel treePanel = new DCPanel(WidgetUtils.BG_COLOR_BRIGHTEST, WidgetUtils.BG_COLOR_BRIGHT);
        treePanel.setBorder(WidgetUtils.BORDER_WIDE);
        treePanel.setLayout(new BorderLayout());
        treePanel.add((Component)WidgetUtils.scrolleable((JComponent)this._categoryTree), "Center");
        DCPanel panel = new DCPanel(WidgetUtils.BG_COLOR_LESS_DARK, WidgetUtils.BG_COLOR_DARK);
        panel.setLayout(new BorderLayout());
        panel.add((Component)new CollapsibleTreePanel(treePanel), "West");
        panel.add((Component)regexDetailsPanel, "Center");
        this.updateCategories();
        return panel;
    }

    private JPanel createRegexDetailsPanel() {
        JToolBar toolBar = WidgetFactory.createToolBar();
        toolBar.add(Box.createHorizontalGlue());
        toolBar.add(this._importRegexButton);
        toolBar.add(this._viewOnlineButton);
        DCPanel toolBarPanel = new DCPanel(WidgetUtils.BG_COLOR_DARK, WidgetUtils.BG_COLOR_LESS_DARK);
        toolBarPanel.setLayout(new BorderLayout());
        toolBarPanel.add((Component)toolBar, "Center");
        DCPanel panel = new DCPanel(WidgetUtils.BG_COLOR_DARK, WidgetUtils.BG_COLOR_DARK);
        panel.setLayout(new BorderLayout());
        panel.add((Component)this._regexSelectionTable.toPanel(), "North");
        panel.add((Component)WidgetUtils.scrolleable(this._regexDescriptionLabel), "Center");
        panel.add((Component)toolBarPanel, "South");
        return panel;
    }

    private void updateCategories() {
        new Thread(){

            @Override
            public void run() {
                DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Categories");
                RegexSwapDialog.this._client.refreshCategories();
                Collection<Category> categories = RegexSwapDialog.this._client.getCategories();
                for (Category category : categories) {
                    DefaultMutableTreeNode categoryNode = new DefaultMutableTreeNode(category);
                    rootNode.add(categoryNode);
                }
                DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
                RegexSwapDialog.this._categoryTree.setModel((TreeModel)treeModel);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCategorySelected(Category category) {
        List<Regex> regexes = this._client.getRegexes(category);
        DefaultTableModel tableModel = new DefaultTableModel(TABLE_HEADERS, regexes.size());
        if (!regexes.isEmpty()) {
            for (int i = 0; i < regexes.size(); ++i) {
                Regex regex = regexes.get(i);
                tableModel.setValueAt(regex.getName(), i, 0);
                tableModel.setValueAt(regex.getPositiveVotes() + "/" + regex.getNegativeVotes(), i, 1);
                tableModel.setValueAt(regex.getAuthor(), i, 2);
            }
        }
        DCTable dCTable = this._regexSelectionTable;
        synchronized (dCTable) {
            this._regexSelectionTable.setModel(tableModel);
            this._regexSelectionTable.updateUI();
        }
    }

    private void onRegexSelected(Regex regex) {
        this._selectedRegex = regex;
        if (regex == null) {
            this._importRegexButton.setEnabled(false);
            this._viewOnlineButton.setEnabled(false);
            this._regexDescriptionLabel.setText("No regex selected");
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("<b>Expression</b>:\n");
            sb.append(regex.getExpression());
            sb.append("\n\n<b>Description</b>:\n");
            sb.append(regex.getDescription());
            sb.append("\n\n<b>Submission date</b>:\n");
            sb.append(new DateTime(regex.getTimestamp() * 1000L).toString());
            this._regexDescriptionLabel.setText(sb.toString());
            this._importRegexButton.setEnabled(true);
            this._viewOnlineButton.setEnabled(true);
        }
    }

    @Override
    protected String getBannerTitle() {
        return "RegexSwap browser";
    }

    @Override
    protected int getDialogWidth() {
        return 650;
    }

    @Override
    public String getWindowTitle() {
        return "RegexSwap browser";
    }

    @Override
    protected boolean isWindowResizable() {
        return true;
    }
}

