/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.regexswap;

import java.util.Collection;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.eobjects.analyzer.reference.StringPattern;
import org.eobjects.datacleaner.actions.LoginChangeListener;
import org.eobjects.datacleaner.regexswap.Category;
import org.eobjects.datacleaner.regexswap.Regex;
import org.eobjects.datacleaner.regexswap.RegexSwapClient;
import org.eobjects.datacleaner.regexswap.RegexSwapStringPattern;
import org.eobjects.datacleaner.user.MutableReferenceDataCatalog;
import org.eobjects.datacleaner.user.UsageLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexSwapUserPreferencesHandler
implements LoginChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(RegexSwapUserPreferencesHandler.class);
    private final RegexSwapClient _client;
    private final MutableReferenceDataCatalog _referenceDataCatalog;
    private final UsageLogger _usageLogger;

    public RegexSwapUserPreferencesHandler(MutableReferenceDataCatalog referenceDataCatalog, HttpClient httpClient, UsageLogger usageLogger) {
        this._referenceDataCatalog = referenceDataCatalog;
        this._client = new RegexSwapClient(httpClient);
        this._usageLogger = usageLogger;
    }

    public boolean isLoaded() {
        String[] stringPatternNames;
        for (String name : stringPatternNames = this._referenceDataCatalog.getStringPatternNames()) {
            StringPattern stringPattern = this._referenceDataCatalog.getStringPattern(name);
            if (!(stringPattern instanceof RegexSwapStringPattern)) continue;
            return true;
        }
        return false;
    }

    public void loadInitialRegexes() {
        logger.info("Loading initial regexes from RegexSwap");
        this._usageLogger.log("RegexSwap: Initial download");
        Collection<Category> categories = this._client.getCategories();
        for (Category category : categories) {
            List<Regex> regexes = this._client.getRegexes(category);
            if (regexes == null || regexes.isEmpty()) continue;
            logger.info("Loading {} regexes from RegexSwap category '{}'", (Object)regexes.size(), (Object)category.getName());
            for (Regex regex : regexes) {
                if (!this._referenceDataCatalog.containsStringPattern(regex.getName())) {
                    logger.debug("Adding regex: {}", (Object)regex);
                    this._referenceDataCatalog.addStringPattern(new RegexSwapStringPattern(regex));
                    continue;
                }
                logger.debug("Omitting regex: {}", (Object)regex);
            }
        }
    }

    @Override
    public void onLoginStateChanged(boolean loggedIn, String username) {
        if (loggedIn) {
            logger.info("User logged in as {}, checking for regexes from RegexSwap", (Object)username);
            if (!this.isLoaded()) {
                new Thread(){

                    @Override
                    public void run() {
                        RegexSwapUserPreferencesHandler.this.loadInitialRegexes();
                    }
                }.start();
            }
        }
    }
}

