/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.user;

import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import org.eobjects.datacleaner.user.AuthenticationService;
import org.eobjects.datacleaner.user.Jcrypt;
import org.eobjects.datacleaner.util.HttpXmlUtils;

public class DCAuthenticationService
implements AuthenticationService {
    private final HttpXmlUtils _httpXmlUtils;

    @Inject
    protected DCAuthenticationService(HttpXmlUtils httpXmlUtils) {
        this._httpXmlUtils = httpXmlUtils;
    }

    @Override
    public boolean auth(String username, char[] password) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        try {
            String salt = this._httpXmlUtils.getUrlContent("http://datacleaner.org/ws/get_salt", params);
            if (salt != null && !"not found".equals(salt)) {
                String hashedPassword = Jcrypt.crypt(salt, new String(password));
                params.put("hashed_password", hashedPassword);
                String accepted = this._httpXmlUtils.getUrlContent("http://datacleaner.org/ws/login", params);
                if ("true".equals(accepted)) {
                    return true;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return false;
    }
}

