/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.user;

import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfigurationImpl;
import org.eobjects.analyzer.configuration.ConfigurationReaderInterceptor;
import org.eobjects.analyzer.configuration.JaxbConfigurationReader;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.connection.DatastoreCatalogImpl;
import org.eobjects.analyzer.descriptors.DescriptorProvider;
import org.eobjects.analyzer.descriptors.SimpleDescriptorProvider;
import org.eobjects.analyzer.job.concurrent.SingleThreadedTaskRunner;
import org.eobjects.analyzer.job.concurrent.TaskRunner;
import org.eobjects.analyzer.reference.ReferenceDataCatalog;
import org.eobjects.analyzer.reference.ReferenceDataCatalogImpl;
import org.eobjects.analyzer.storage.InMemoryStorageProvider;
import org.eobjects.analyzer.storage.StorageProvider;
import org.eobjects.datacleaner.user.DataCleanerConfigurationReaderInterceptor;
import org.eobjects.datacleaner.user.ExtensionPackage;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.ResourceManager;
import org.eobjects.metamodel.util.LazyRef;
import org.eobjects.metamodel.util.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCleanerConfigurationReader
extends LazyRef<AnalyzerBeansConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(DataCleanerConfigurationReader.class);
    private final FileObject _dataCleanerHome;
    private final FileObject _configurationFile;
    private final Ref<UserPreferences> _userPreferencesRef;

    public DataCleanerConfigurationReader(FileObject dataCleanerHome, FileObject configurationFile, Ref<UserPreferences> userPreferencesRef) {
        this._dataCleanerHome = dataCleanerHome;
        this._configurationFile = configurationFile;
        this._userPreferencesRef = userPreferencesRef;
    }

    protected AnalyzerBeansConfiguration fetch() {
        AnalyzerBeansConfiguration c;
        boolean exists;
        UserPreferences userPreferences = (UserPreferences)this._userPreferencesRef.get();
        List<ExtensionPackage> extensionPackages = userPreferences.getExtensionPackages();
        for (ExtensionPackage extensionPackage : extensionPackages) {
            extensionPackage.loadExtension();
        }
        JaxbConfigurationReader configurationReader = new JaxbConfigurationReader((ConfigurationReaderInterceptor)new DataCleanerConfigurationReaderInterceptor(this._dataCleanerHome));
        try {
            exists = this._configurationFile != null && this._configurationFile.exists();
        }
        catch (FileSystemException e1) {
            logger.debug("Could not determine if configuration file exists");
            exists = false;
        }
        if (exists) {
            try {
                c = configurationReader.create(this._configurationFile.getContent().getInputStream());
                logger.info("Succesfully read configuration from {}", (Object)this._configurationFile.getName().getPath());
            }
            catch (FileSystemException e) {
                throw new IllegalStateException("Unexpected error while reading configuration file: " + this._configurationFile, e);
            }
        } else {
            logger.info("Configuration file does not exist, reading built-in configuration.");
            c = this.getConfigurationFromClasspath(configurationReader);
        }
        return c;
    }

    private AnalyzerBeansConfiguration getConfigurationFromClasspath(JaxbConfigurationReader configurationReader) {
        logger.info("Reading conf.xml from classpath");
        try {
            return configurationReader.create(ResourceManager.getInstance().getUrl("datacleaner-home/conf.xml", new ClassLoader[0]).openStream());
        }
        catch (Exception ex2) {
            logger.warn("Unexpected error while reading conf.xml from classpath!", (Throwable)ex2);
            logger.warn("Creating a bare-minimum configuration because of previous errors!");
            return new AnalyzerBeansConfigurationImpl((DatastoreCatalog)new DatastoreCatalogImpl(new Datastore[0]), (ReferenceDataCatalog)new ReferenceDataCatalogImpl(), (DescriptorProvider)new SimpleDescriptorProvider(), (TaskRunner)new SingleThreadedTaskRunner(), (StorageProvider)new InMemoryStorageProvider());
        }
    }
}

