/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.user;

import java.io.File;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.eobjects.analyzer.configuration.ConfigurationReaderInterceptor;
import org.eobjects.analyzer.configuration.DefaultConfigurationReaderInterceptor;
import org.eobjects.datacleaner.user.ExtensionPackage;
import org.eobjects.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataCleanerConfigurationReaderInterceptor
extends DefaultConfigurationReaderInterceptor
implements ConfigurationReaderInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DataCleanerConfigurationReaderInterceptor.class);
    private final FileObject _dataCleanerHome;

    public DataCleanerConfigurationReaderInterceptor(FileObject dataCleanerHome) {
        this._dataCleanerHome = dataCleanerHome;
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader classLoader = ExtensionPackage.getExtensionClassLoader();
        return Class.forName(className, true, classLoader);
    }

    public String createFilename(String filename) {
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        if (file.isAbsolute()) {
            return filename;
        }
        try {
            FileObject fileObject = this._dataCleanerHome.resolveFile(filename);
            return fileObject.getName().getPathDecoded();
        }
        catch (FileSystemException e) {
            logger.warn("Could not resolve absolute path using VFS: " + filename, (Throwable)e);
            return filename;
        }
    }

    public String getTemporaryStorageDirectory() {
        try {
            if (this._dataCleanerHome.isWriteable()) {
                return this._dataCleanerHome.resolveFile("temp").getName().getPathDecoded();
            }
        }
        catch (FileSystemException e) {
            logger.warn("Could not resolve temp directory", (Throwable)e);
        }
        return FileHelper.getTempDir().getAbsolutePath();
    }
}

