/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.user;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.eobjects.analyzer.util.ClassLoaderUtils;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.analyzer.util.VFSUtils;
import org.eobjects.datacleaner.Main;
import org.eobjects.datacleaner.util.ResourceManager;
import org.eobjects.metamodel.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataCleanerHome {
    private static final Logger logger = LoggerFactory.getLogger(DataCleanerHome.class);
    private static final FileObject _dataCleanerHome;

    private static FileObject findDataCleanerHome() throws FileSystemException {
        FileSystemManager manager = VFSUtils.getFileSystemManager();
        FileObject candidate = null;
        String env = System.getenv("DATACLEANER_HOME");
        if (!StringUtils.isNullOrEmpty((String)env)) {
            candidate = manager.resolveFile(env);
        }
        if (!DataCleanerHome.isUsable(candidate)) {
            if (ClassLoaderUtils.IS_WEB_START) {
                String userHomePath = System.getProperty("user.home");
                if (userHomePath == null) {
                    throw new IllegalStateException("Could not determine user home directory: " + candidate);
                }
                candidate = manager.resolveFile(userHomePath + File.separatorChar + ".datacleaner" + File.separatorChar + Main.VERSION);
            } else {
                candidate = manager.resolveFile(".");
            }
        }
        if ("true".equalsIgnoreCase(System.getProperty("datacleaner.sandbox"))) {
            return candidate;
        }
        if (!DataCleanerHome.isUsable(candidate)) {
            if (!candidate.exists()) {
                candidate.createFolder();
            }
            if (candidate.isWriteable()) {
                DataCleanerHome.copyIfNonExisting(candidate, manager, "conf.xml");
                DataCleanerHome.copyIfNonExisting(candidate, manager, "examples/countrycodes.csv");
                DataCleanerHome.copyIfNonExisting(candidate, manager, "examples/employees.analysis.xml");
                DataCleanerHome.copyIfNonExisting(candidate, manager, "examples/duplicate_customer_detection.analysis.xml");
                DataCleanerHome.copyIfNonExisting(candidate, manager, "examples/customer_data_cleansing.analysis.xml");
                DataCleanerHome.copyIfNonExisting(candidate, manager, "examples/write_order_information.analysis.xml");
                DataCleanerHome.copyIfNonExisting(candidate, manager, "examples/customer_data_completeness.analysis.xml");
            }
        }
        return candidate;
    }

    public static FileObject get() {
        return _dataCleanerHome;
    }

    private static void copyIfNonExisting(FileObject candidate, FileSystemManager manager, String filename) throws FileSystemException {
        FileObject file = candidate.resolveFile(filename);
        if (file.exists()) {
            logger.info("File already exists in DATACLEANER_HOME: " + filename);
            return;
        }
        FileObject parentFile = file.getParent();
        if (!parentFile.exists()) {
            parentFile.createFolder();
        }
        ResourceManager resourceManager = ResourceManager.getInstance();
        URL url = resourceManager.getUrl("datacleaner-home/" + filename, new ClassLoader[0]);
        InputStream in = null;
        OutputStream out = null;
        try {
            in = url.openStream();
            out = file.getContent().getOutputStream();
            FileHelper.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{in, out});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{in, out});
    }

    private static boolean isUsable(FileObject candidate) throws FileSystemException {
        FileObject conf;
        return candidate != null && candidate.exists() && candidate.getType() == FileType.FOLDER && (conf = candidate.resolveFile("conf.xml")).exists() && conf.getType() == FileType.FILE;
    }

    static {
        try {
            _dataCleanerHome = DataCleanerHome.findDataCleanerHome();
        }
        catch (FileSystemException e) {
            throw new IllegalStateException(e);
        }
    }
}

