/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.user;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eobjects.analyzer.descriptors.ClasspathScanDescriptorProvider;
import org.eobjects.analyzer.descriptors.DescriptorProvider;
import org.eobjects.analyzer.util.ClassLoaderUtils;
import org.eobjects.analyzer.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensionPackage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ExtensionPackage.class);
    private static ClassLoader _latestClassLoader = ClassLoaderUtils.getParentClassLoader();
    private transient boolean _loaded = false;
    private transient int _loadedAnalyzers;
    private transient int _loadedTransformers;
    private transient int _loadedFilters;
    private transient int _loadedRenderers;
    private transient ClassLoader _classLoader;
    private final File[] _files;
    private final String _name;
    private final String _scanPackage;
    private final boolean _scanRecursive;
    private final Map<String, String> _additionalProperties;

    public ExtensionPackage(String name, String scanPackage, boolean scanRecursive, File[] files) {
        this._name = name;
        if (scanPackage == null) {
            scanPackage = "";
        }
        this._scanPackage = scanPackage;
        this._scanRecursive = scanRecursive;
        this._files = files;
        this._additionalProperties = new HashMap<String, String>();
    }

    public File[] getFiles() {
        return Arrays.copyOf(this._files, this._files.length);
    }

    public String getName() {
        return this._name;
    }

    public String getScanPackage() {
        return this._scanPackage;
    }

    public boolean isScanRecursive() {
        return this._scanRecursive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadExtension() {
        Class<ExtensionPackage> clazz = ExtensionPackage.class;
        synchronized (ExtensionPackage.class) {
            this._classLoader = _latestClassLoader = ClassLoaderUtils.createClassLoader((File[])this._files, (ClassLoader)_latestClassLoader);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public ExtensionPackage loadDescriptors(DescriptorProvider descriptorProvider) throws IllegalStateException {
        if (!this._loaded) {
            if (!(descriptorProvider instanceof ClasspathScanDescriptorProvider)) {
                throw new IllegalStateException("Can only load user extensions when descriptor provider is of classpath scanner type.");
            }
            ClasspathScanDescriptorProvider classpathScanner = (ClasspathScanDescriptorProvider)descriptorProvider;
            int analyzersBefore = classpathScanner.getAnalyzerBeanDescriptors().size();
            int transformersBefore = classpathScanner.getTransformerBeanDescriptors().size();
            int filtersBefore = classpathScanner.getFilterBeanDescriptors().size();
            int renderersBefore = classpathScanner.getRendererBeanDescriptors().size();
            if (this._classLoader == null) {
                this.loadExtension();
            }
            classpathScanner = classpathScanner.scanPackage(this._scanPackage, this._scanRecursive, this._classLoader, true, this._files);
            this._loadedAnalyzers = classpathScanner.getAnalyzerBeanDescriptors().size() - analyzersBefore;
            this._loadedTransformers = classpathScanner.getTransformerBeanDescriptors().size() - transformersBefore;
            this._loadedFilters = classpathScanner.getFilterBeanDescriptors().size() - filtersBefore;
            this._loadedRenderers = classpathScanner.getRendererBeanDescriptors().size() - renderersBefore;
            this._loaded = true;
            logger.info("Succesfully loaded extension '{}' containing {} analyzers, {} transformers, {} filters, {} renderers", new Object[]{this.getName(), this.getLoadedAnalyzers(), this.getLoadedTransformers(), this.getLoadedFilters(), this.getLoadedRenderers()});
        }
        return this;
    }

    public Map<String, String> getAdditionalProperties() {
        return this._additionalProperties;
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    public int getLoadedRenderers() {
        return this._loadedRenderers;
    }

    public int getLoadedAnalyzers() {
        return this._loadedAnalyzers;
    }

    public int getLoadedFilters() {
        return this._loadedFilters;
    }

    public int getLoadedTransformers() {
        return this._loadedTransformers;
    }

    public static String autoDetectPackageName(File file) {
        try {
            HashSet<String> packageNames = new HashSet<String>();
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                logger.debug("Considering package of entry '{}'", (Object)name);
                int lastIndexOfSlash = name.lastIndexOf(47);
                if (lastIndexOfSlash == -1) continue;
                name = name.substring(0, lastIndexOfSlash);
                packageNames.add(name);
            }
            if (packageNames.isEmpty()) {
                return null;
            }
            logger.info("Found {} packages in extension jar: {}", (Object)packageNames.size(), packageNames);
            String packageName = StringUtils.getLongestCommonToken(packageNames, (char)'/');
            if (packageName == "") {
                logger.debug("No common package prefix");
                return null;
            }
            packageName = packageName.replace('/', '.');
            return packageName;
        }
        catch (Exception e) {
            logger.warn("Error occurred while auto detecting package name", (Throwable)e);
            return null;
        }
    }

    public static ClassLoader getExtensionClassLoader() {
        return _latestClassLoader;
    }
}

