/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.user;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.util.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorConnection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(MonitorConnection.class);
    private final String _hostname;
    private final int _port;
    private final String _contextPath;
    private final boolean _https;
    private final String _tenantId;
    private final String _username;
    private final String _encodedPassword;

    public MonitorConnection(String hostname, int port, String contextPath, boolean isHttps, String tenantId, String username, char[] password) {
        this(hostname, port, contextPath, isHttps, tenantId, username, SecurityUtils.encodePassword(password));
    }

    public MonitorConnection(String hostname, int port, String contextPath, boolean isHttps, String tenantId, String username, String encodedPassword) {
        this._hostname = hostname;
        this._port = port;
        this._contextPath = this.removeBeginningSlash(contextPath);
        this._https = isHttps;
        this._tenantId = tenantId;
        this._username = username;
        this._encodedPassword = encodedPassword;
    }

    public String getHostname() {
        return this._hostname;
    }

    public int getPort() {
        return this._port;
    }

    public boolean isHttps() {
        return this._https;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getEncodedPassword() {
        return this._encodedPassword;
    }

    public String getTenantId() {
        return this._tenantId;
    }

    public String getUsername() {
        return this._username;
    }

    public String getBaseUrl() {
        return "" + (this._https ? "https://" : "http://") + this._hostname + ":" + this._port + (StringUtils.isNullOrEmpty((String)this._contextPath) ? "" : "/" + this._contextPath);
    }

    public String getRepositoryUrl() {
        return this.getBaseUrl() + "/repository" + (StringUtils.isNullOrEmpty((String)this._tenantId) ? "" : "/" + this._tenantId);
    }

    public boolean isAuthenticationEnabled() {
        return !StringUtils.isNullOrEmpty((String)this._username);
    }

    public void prepareClient(HttpClient httpClient) {
        if (this.isAuthenticationEnabled()) {
            if (!(httpClient instanceof DefaultHttpClient)) {
                throw new IllegalStateException("Unexpected http client type: " + httpClient);
            }
            CredentialsProvider credentialsProvider = ((DefaultHttpClient)httpClient).getCredentialsProvider();
            String encodedPassword = this.getEncodedPassword();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.getUsername(), SecurityUtils.decodePassword(encodedPassword));
            ArrayList<String> authpref = new ArrayList<String>();
            authpref.add("Basic");
            authpref.add("Digest");
            httpClient.getParams().setParameter("http.auth.proxy-scheme-pref", authpref);
            credentialsProvider.setCredentials(new AuthScope(this.getHostname(), this.getPort()), (Credentials)credentials);
        }
    }

    public boolean matchesURI(String uriString) {
        if (uriString == null) {
            return false;
        }
        try {
            URI uri = new URI(uriString);
            return this.matchesURI(uri);
        }
        catch (URISyntaxException e) {
            logger.debug("Failed to create URI of string: " + uriString, (Throwable)e);
            return false;
        }
    }

    public boolean matchesURI(URI uri) {
        int port;
        if (uri == null) {
            return false;
        }
        String host = uri.getHost();
        if (host.equals(this._hostname) && ((port = uri.getPort()) == this._port || port == -1)) {
            String path = this.removeBeginningSlash(uri.getPath());
            if (StringUtils.isNullOrEmpty((String)this._contextPath) || path.startsWith(this._contextPath)) {
                return true;
            }
        }
        return false;
    }

    private String removeBeginningSlash(String contextPath) {
        if (contextPath == null) {
            return null;
        }
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        return contextPath;
    }
}

