/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.user;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.connection.DatastoreCatalog;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.user.DatastoreChangeListener;
import org.eobjects.datacleaner.user.UserPreferences;

public class MutableDatastoreCatalog
implements DatastoreCatalog,
Serializable {
    private static final long serialVersionUID = 1L;
    private final DatastoreCatalog _immutableDelegate;
    private final List<Datastore> _datastores;
    private final List<DatastoreChangeListener> _listeners = new LinkedList<DatastoreChangeListener>();

    public MutableDatastoreCatalog(DatastoreCatalog immutableDelegate, UserPreferences userPreferences) {
        String[] datastoreNames;
        this._immutableDelegate = immutableDelegate;
        this._datastores = userPreferences.getUserDatastores();
        for (String name : datastoreNames = immutableDelegate.getDatastoreNames()) {
            if (this.containsDatastore(name)) {
                this.removeDatastore(this.getDatastore(name));
            }
            this.addDatastore(immutableDelegate.getDatastore(name));
        }
    }

    public boolean isDatastoreMutable(String name) {
        return this._immutableDelegate.getDatastore(name) == null;
    }

    public boolean containsDatastore(String name) {
        for (Datastore datastore : this._datastores) {
            if (!name.equals(datastore.getName())) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeDatastore(Datastore ds) {
        this._datastores.remove(ds);
        for (DatastoreChangeListener listener : this._listeners) {
            listener.onRemove(ds);
        }
    }

    public synchronized void addDatastore(Datastore ds) {
        String name = ds.getName();
        if (StringUtils.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Datastore has no name!");
        }
        for (Datastore datastore : this._datastores) {
            if (!name.equals(datastore.getName())) continue;
            throw new IllegalArgumentException("Datastore name '" + name + "' is not unique!");
        }
        this._datastores.add(ds);
        for (DatastoreChangeListener listener : this._listeners) {
            listener.onAdd(ds);
        }
    }

    public String[] getDatastoreNames() {
        String[] names = new String[this._datastores.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this._datastores.get(i).getName();
        }
        return names;
    }

    public Datastore getDatastore(String name) {
        if (name == null) {
            return null;
        }
        for (Datastore datastore : this._datastores) {
            if (!name.equals(datastore.getName())) continue;
            return datastore;
        }
        return null;
    }

    public void addListener(DatastoreChangeListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(DatastoreChangeListener listener) {
        this._listeners.remove(listener);
    }
}

