/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.user;

import java.util.ArrayList;
import java.util.List;
import org.eobjects.analyzer.descriptors.ComponentDescriptor;
import org.eobjects.analyzer.descriptors.Descriptors;
import org.eobjects.analyzer.lifecycle.LifeCycleHelper;
import org.eobjects.analyzer.reference.Dictionary;
import org.eobjects.analyzer.reference.ReferenceDataCatalog;
import org.eobjects.analyzer.reference.ReferenceDataCatalogImpl;
import org.eobjects.analyzer.reference.StringPattern;
import org.eobjects.analyzer.reference.SynonymCatalog;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.user.DictionaryChangeListener;
import org.eobjects.datacleaner.user.StringPatternChangeListener;
import org.eobjects.datacleaner.user.SynonymCatalogChangeListener;
import org.eobjects.datacleaner.user.UserPreferences;

public class MutableReferenceDataCatalog
implements ReferenceDataCatalog {
    private static final long serialVersionUID = 1L;
    private final List<Dictionary> _dictionaries;
    private final List<DictionaryChangeListener> _dictionaryListeners = new ArrayList<DictionaryChangeListener>();
    private final List<SynonymCatalog> _synonymCatalogs;
    private final List<SynonymCatalogChangeListener> _synonymCatalogListeners = new ArrayList<SynonymCatalogChangeListener>();
    private final List<StringPattern> _stringPatterns;
    private final List<StringPatternChangeListener> _stringPatternListeners = new ArrayList<StringPatternChangeListener>();
    private final ReferenceDataCatalog _immutableDelegate;
    private final LifeCycleHelper _lifeCycleHelper;

    public MutableReferenceDataCatalog() {
        this._immutableDelegate = new ReferenceDataCatalogImpl();
        this._lifeCycleHelper = new LifeCycleHelper(null, null);
        this._dictionaries = new ArrayList<Dictionary>();
        this._synonymCatalogs = new ArrayList<SynonymCatalog>();
        this._stringPatterns = new ArrayList<StringPattern>();
    }

    public MutableReferenceDataCatalog(ReferenceDataCatalog immutableDelegate, UserPreferences userPreferences, LifeCycleHelper lifeCycleHelper) {
        String[] names;
        this._immutableDelegate = immutableDelegate;
        this._lifeCycleHelper = lifeCycleHelper;
        this._dictionaries = userPreferences.getUserDictionaries();
        this._synonymCatalogs = userPreferences.getUserSynonymCatalogs();
        this._stringPatterns = userPreferences.getUserStringPatterns();
        for (String name : names = this._immutableDelegate.getDictionaryNames()) {
            if (this.containsDictionary(name)) {
                this._dictionaries.remove(this.getDictionary(name));
            }
            this.addDictionary(this._immutableDelegate.getDictionary(name));
        }
        for (String name : names = this._immutableDelegate.getSynonymCatalogNames()) {
            if (this.containsSynonymCatalog(name)) {
                this._synonymCatalogs.remove(this.getSynonymCatalog(name));
            }
            this.addSynonymCatalog(this._immutableDelegate.getSynonymCatalog(name));
        }
        for (String name : names = this._immutableDelegate.getStringPatternNames()) {
            if (this.containsStringPattern(name)) {
                this._stringPatterns.remove(this.getStringPattern(name));
            }
            this.addStringPattern(this._immutableDelegate.getStringPattern(name));
        }
        this.assignProvidedProperties(this._dictionaries.toArray());
        this.assignProvidedProperties(this._synonymCatalogs.toArray());
        this.assignProvidedProperties(this._stringPatterns.toArray());
    }

    private void assignProvidedProperties(Object ... objects) {
        for (Object object : objects) {
            ComponentDescriptor descriptor = Descriptors.ofComponent(object.getClass());
            this._lifeCycleHelper.assignProvidedProperties(descriptor, object);
        }
    }

    public String[] getDictionaryNames() {
        String[] result = new String[this._dictionaries.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this._dictionaries.get(i).getName();
        }
        return result;
    }

    public boolean isDictionaryMutable(String name) {
        return this._immutableDelegate.getDictionary(name) == null;
    }

    public boolean containsDictionary(String name) {
        for (Dictionary dictionary : this._dictionaries) {
            if (!name.equals(dictionary.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isSynonymCatalogMutable(String name) {
        return this._immutableDelegate.getSynonymCatalog(name) == null;
    }

    public boolean isStringPatternMutable(String name) {
        return this._immutableDelegate.getStringPattern(name) == null;
    }

    public boolean containsSynonymCatalog(String name) {
        for (SynonymCatalog sc : this._synonymCatalogs) {
            if (!name.equals(sc.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsStringPattern(String name) {
        for (StringPattern sp : this._stringPatterns) {
            if (!name.equals(sp.getName())) continue;
            return true;
        }
        return false;
    }

    public void addDictionary(Dictionary dict) {
        String name = dict.getName();
        if (StringUtils.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Dictionary has no name!");
        }
        for (Dictionary dictionary : this._dictionaries) {
            if (!name.equals(dictionary.getName())) continue;
            throw new IllegalArgumentException("Dictionary name '" + name + "' is not unique!");
        }
        this.assignProvidedProperties(dict);
        this._dictionaries.add(dict);
        for (DictionaryChangeListener listener : this._dictionaryListeners) {
            listener.onAdd(dict);
        }
    }

    public void removeDictionary(Dictionary dict) {
        if (!this.isDictionaryMutable(dict.getName())) {
            throw new IllegalArgumentException("Dictionary '" + dict.getName() + " is not removeable");
        }
        if (this._dictionaries.remove(dict)) {
            for (DictionaryChangeListener listener : this._dictionaryListeners) {
                listener.onRemove(dict);
            }
        }
    }

    public void addStringPattern(StringPattern sp) {
        String name = sp.getName();
        if (StringUtils.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("StringPattern has no name!");
        }
        for (StringPattern stringPattern : this._stringPatterns) {
            if (!name.equals(stringPattern.getName())) continue;
            throw new IllegalArgumentException("StringPattern name '" + name + "' is not unique!");
        }
        this.assignProvidedProperties(sp);
        this._stringPatterns.add(sp);
        for (StringPatternChangeListener listener : this._stringPatternListeners) {
            listener.onAdd(sp);
        }
    }

    public void removeStringPattern(StringPattern sp) {
        if (!this.isStringPatternMutable(sp.getName())) {
            throw new IllegalArgumentException("StringPattern '" + sp.getName() + " is not removeable");
        }
        if (this._stringPatterns.remove(sp)) {
            for (StringPatternChangeListener listener : this._stringPatternListeners) {
                listener.onRemove(sp);
            }
        }
    }

    public Dictionary getDictionary(String name) {
        if (name != null) {
            for (Dictionary dict : this._dictionaries) {
                if (!name.equals(dict.getName())) continue;
                return dict;
            }
        }
        return null;
    }

    public String[] getSynonymCatalogNames() {
        String[] result = new String[this._synonymCatalogs.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this._synonymCatalogs.get(i).getName();
        }
        return result;
    }

    public void addSynonymCatalog(SynonymCatalog sc) {
        String name = sc.getName();
        if (StringUtils.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("SynonymCatalog has no name!");
        }
        for (SynonymCatalog synonymCatalog : this._synonymCatalogs) {
            if (!name.equals(synonymCatalog.getName())) continue;
            throw new IllegalArgumentException("SynonymCatalog name '" + name + "' is not unique!");
        }
        this.assignProvidedProperties(sc);
        this._synonymCatalogs.add(sc);
        for (SynonymCatalogChangeListener listener : this._synonymCatalogListeners) {
            listener.onAdd(sc);
        }
    }

    public void removeSynonymCatalog(SynonymCatalog sc) {
        if (!this.isSynonymCatalogMutable(sc.getName())) {
            throw new IllegalArgumentException("Synonym catalog '" + sc.getName() + " is not removeable");
        }
        if (this._synonymCatalogs.remove(sc)) {
            for (SynonymCatalogChangeListener listener : this._synonymCatalogListeners) {
                listener.onRemove(sc);
            }
        }
    }

    public SynonymCatalog getSynonymCatalog(String name) {
        if (name != null) {
            for (SynonymCatalog sc : this._synonymCatalogs) {
                if (!name.equals(sc.getName())) continue;
                return sc;
            }
        }
        return null;
    }

    public String[] getStringPatternNames() {
        String[] names = new String[this._stringPatterns.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this._stringPatterns.get(i).getName();
        }
        return names;
    }

    public StringPattern getStringPattern(String name) {
        if (name != null) {
            for (StringPattern sp : this._stringPatterns) {
                if (!name.equals(sp.getName())) continue;
                return sp;
            }
        }
        return null;
    }

    public void addDictionaryListener(DictionaryChangeListener listener) {
        this._dictionaryListeners.add(listener);
    }

    public void removeDictionaryListener(DictionaryChangeListener listener) {
        this._dictionaryListeners.remove(listener);
    }

    public void addSynonymCatalogListener(SynonymCatalogChangeListener listener) {
        this._synonymCatalogListeners.add(listener);
    }

    public void removeSynonymCatalogListener(SynonymCatalogChangeListener listener) {
        this._synonymCatalogListeners.remove(listener);
    }

    public void addStringPatternListener(StringPatternChangeListener listener) {
        this._stringPatternListeners.add(listener);
    }

    public void removeStringPatternListener(StringPatternChangeListener listener) {
        this._stringPatternListeners.remove(listener);
    }
}

