/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.user;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.eobjects.datacleaner.Main;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.HttpXmlUtils;
import org.eobjects.metamodel.util.SharedExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UsageLogger {
    private static final Logger logger = LoggerFactory.getLogger(UsageLogger.class);
    private static final String NOT_LOGGED_IN_USERNAME = "[not-logged-in]";
    private final UserPreferences _userPreferences;
    private final HttpXmlUtils _httpXmlUtils;
    private final ExecutorService _executorService;

    @Inject
    protected UsageLogger(UserPreferences userPreferences, HttpXmlUtils httpXmlUtils) {
        this._userPreferences = userPreferences;
        this._httpXmlUtils = httpXmlUtils;
        this._executorService = SharedExecutorService.get();
    }

    public void logApplicationStartup() {
        String embeddedClient = System.getProperty("datacleaner.embed.client");
        String action = embeddedClient == null ? "Startup" : "Startup (embedded in " + embeddedClient + ")";
        String username = this.getUsername();
        logger.debug("Logging '{}'", (Object)action);
        UsageLoggerRunnable runnable = new UsageLoggerRunnable(username, action);
        this._executorService.submit(runnable);
    }

    private String getUsername() {
        if (this._userPreferences.isLoggedIn()) {
            return this._userPreferences.getUsername();
        }
        return NOT_LOGGED_IN_USERNAME;
    }

    public void logApplicationShutdown() {
        String action = "Shutdown";
        String username = this.getUsername();
        logger.debug("Logging '{}'", (Object)"Shutdown");
        UsageLoggerRunnable runnable = new UsageLoggerRunnable(username, "Shutdown");
        try {
            this._executorService.submit(runnable).get();
        }
        catch (Exception e) {
            logger.warn("Exception occurred sending shutdown message", (Throwable)e);
        }
        this._executorService.shutdown();
    }

    public void log(String action) {
        if (!this._userPreferences.isLoggedIn()) {
            logger.debug("Not logging '{}', because user is not logged in", (Object)action);
            return;
        }
        String username = this.getUsername();
        logger.debug("Logging '{}'", (Object)action);
        UsageLoggerRunnable runnable = new UsageLoggerRunnable(username, action);
        this._executorService.submit(runnable);
    }

    private final class UsageLoggerRunnable
    implements Runnable {
        private final String _username;
        private final String _action;

        public UsageLoggerRunnable(String username, String action) {
            this._username = username;
            this._action = action;
        }

        @Override
        public void run() {
            try {
                ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
                HttpPost req = new HttpPost("http://datacleaner.org/ws/user_action");
                nameValuePairs.add(new BasicNameValuePair("username", this._username));
                nameValuePairs.add(new BasicNameValuePair("action", this._action));
                nameValuePairs.add(new BasicNameValuePair("version", Main.VERSION));
                req.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
                HttpResponse resp = UsageLogger.this._httpXmlUtils.getHttpClient().execute((HttpUriRequest)req);
                InputStream content = resp.getEntity().getContent();
                String line = new BufferedReader(new InputStreamReader(content)).readLine();
                assert ("success".equals(line));
                logger.debug("Usage logger response: {}", (Object)line);
            }
            catch (Exception e) {
                logger.warn("Could not dispatch usage log for action: {} ({})", (Object)this._action, (Object)e.getMessage());
                logger.debug("Error occurred while dispatching usage log", (Throwable)e);
            }
        }
    }
}

