/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.user;

import java.io.File;
import java.io.InvalidClassException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.reference.Dictionary;
import org.eobjects.analyzer.reference.StringPattern;
import org.eobjects.analyzer.reference.SynonymCatalog;
import org.eobjects.analyzer.util.ChangeAwareObjectInputStream;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.analyzer.util.VFSUtils;
import org.eobjects.datacleaner.actions.LoginChangeListener;
import org.eobjects.datacleaner.user.ExtensionPackage;
import org.eobjects.datacleaner.user.MonitorConnection;
import org.eobjects.datacleaner.user.QuickAnalysisStrategy;
import org.eobjects.datacleaner.user.UserDatabaseDriver;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.metamodel.util.CollectionUtils;
import org.eobjects.metamodel.util.FileHelper;
import org.eobjects.metamodel.util.Func;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPreferencesImpl
implements UserPreferences,
Serializable {
    private static final long serialVersionUID = 6L;
    private static final Logger logger = LoggerFactory.getLogger(UserPreferencesImpl.class);
    private transient FileObject _userPreferencesFile;
    private transient List<LoginChangeListener> loginChangeListeners;
    private List<UserDatabaseDriver> databaseDrivers = new ArrayList<UserDatabaseDriver>();
    private List<ExtensionPackage> extensionPackages = new ArrayList<ExtensionPackage>();
    private List<Datastore> userDatastores = new ArrayList<Datastore>();
    private List<Dictionary> userDictionaries = new ArrayList<Dictionary>();
    private List<StringPattern> userStringPatterns = new ArrayList<StringPattern>();
    private List<SynonymCatalog> userSynonymCatalogs = new ArrayList<SynonymCatalog>();
    private Map<String, String> additionalProperties = new HashMap<String, String>();
    private String username;
    private boolean proxyEnabled = false;
    private boolean proxyAuthenticationEnabled = false;
    private String proxyHostname;
    private int proxyPort = 8080;
    private String proxyUsername;
    private String proxyPassword;
    private List<File> recentJobFiles = new ArrayList<File>();
    private File openDatastoreDirectory;
    private File configuredFileDirectory;
    private File analysisJobDirectory;
    private File saveDatastoreDirectory;
    private File saveDownloadedFilesDirectory;
    private MonitorConnection monitorConnection;
    private QuickAnalysisStrategy quickAnalysisStrategy = new QuickAnalysisStrategy();

    public UserPreferencesImpl(FileObject userPreferencesFile) {
        this._userPreferencesFile = userPreferencesFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static UserPreferences load(FileObject userPreferencesFile, boolean loadDatabaseDrivers) {
        UserPreferencesImpl userPreferencesImpl;
        try {
            if (userPreferencesFile == null || !userPreferencesFile.exists()) {
                logger.info("User preferences file does not exist");
                return new UserPreferencesImpl(userPreferencesFile);
            }
        }
        catch (FileSystemException e1) {
            logger.debug("Could not determine if file exists: {}", (Object)userPreferencesFile);
        }
        ChangeAwareObjectInputStream inputStream = null;
        try {
            inputStream = new ChangeAwareObjectInputStream(userPreferencesFile.getContent().getInputStream());
            inputStream.addRenamedClass("org.eobjects.datacleaner.user.UserPreferences", UserPreferencesImpl.class);
            UserPreferencesImpl result = (UserPreferencesImpl)inputStream.readObject();
            if (loadDatabaseDrivers) {
                List<UserDatabaseDriver> installedDatabaseDrivers = result.getDatabaseDrivers();
                for (UserDatabaseDriver userDatabaseDriver : installedDatabaseDrivers) {
                    try {
                        userDatabaseDriver.loadDriver();
                    }
                    catch (IllegalStateException e) {
                        logger.error("Could not load database driver", (Throwable)e);
                    }
                }
            }
            result._userPreferencesFile = userPreferencesFile;
            userPreferencesImpl = result;
        }
        catch (InvalidClassException e) {
            logger.warn("User preferences file version does not match application version: {}", (Object)e.getMessage());
            UserPreferencesImpl userPreferencesImpl2 = new UserPreferencesImpl(userPreferencesFile);
            FileHelper.safeClose((Object[])new Object[]{inputStream});
            return userPreferencesImpl2;
        }
        catch (Exception e2) {
            logger.warn("Could not read user preferences file", (Throwable)e2);
            UserPreferencesImpl userPreferencesImpl3 = new UserPreferencesImpl(userPreferencesFile);
            {
                catch (Throwable throwable) {
                    FileHelper.safeClose((Object[])new Object[]{inputStream});
                    throw throwable;
                }
            }
            FileHelper.safeClose((Object[])new Object[]{inputStream});
            return userPreferencesImpl3;
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        return userPreferencesImpl;
    }

    @Override
    public void save() {
        if (this._userPreferencesFile == null) {
            logger.debug("Not saving user preferences, since no user preferences file has been provided");
            return;
        }
        logger.info("Saving user preferences to {}", (Object)this._userPreferencesFile.getName().getPath());
        ObjectOutputStream outputStream = null;
        try {
            outputStream = new ObjectOutputStream(this._userPreferencesFile.getContent().getOutputStream());
            outputStream.writeObject(this);
            outputStream.flush();
        }
        catch (Exception e) {
            logger.warn("Unexpected error while saving user preferences", (Throwable)e);
            throw new IllegalStateException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private List<LoginChangeListener> getLoginChangeListeners() {
        if (this.loginChangeListeners == null) {
            this.loginChangeListeners = new ArrayList<LoginChangeListener>();
        }
        return this.loginChangeListeners;
    }

    @Override
    public void addLoginChangeListener(LoginChangeListener listener) {
        this.getLoginChangeListeners().add(listener);
    }

    @Override
    public void removeLoginChangeListener(LoginChangeListener listener) {
        this.getLoginChangeListeners().add(listener);
    }

    @Override
    public File getOpenDatastoreDirectory() {
        if (this.openDatastoreDirectory == null) {
            this.openDatastoreDirectory = new File(".");
        }
        return this.openDatastoreDirectory;
    }

    @Override
    public void setOpenDatastoreDirectory(File openFileDir) {
        this.openDatastoreDirectory = openFileDir;
    }

    @Override
    public File getConfiguredFileDirectory() {
        if (this.configuredFileDirectory == null) {
            this.configuredFileDirectory = new File(".");
        }
        return this.configuredFileDirectory;
    }

    @Override
    public void setConfiguredFileDirectory(File openPropertyFileDirectory) {
        this.configuredFileDirectory = openPropertyFileDirectory;
    }

    @Override
    public File getAnalysisJobDirectory() {
        if (this.analysisJobDirectory == null) {
            this.analysisJobDirectory = new File(".");
        }
        return this.analysisJobDirectory;
    }

    @Override
    public void setAnalysisJobDirectory(File saveFileDirectory) {
        this.analysisJobDirectory = saveFileDirectory;
    }

    @Override
    public File getSaveDatastoreDirectory() {
        if (this.saveDatastoreDirectory == null) {
            this.saveDatastoreDirectory = new File("datastores");
        }
        return this.saveDatastoreDirectory;
    }

    @Override
    public void setSaveDatastoreDirectory(File saveDatastoreDirectory) {
        this.saveDatastoreDirectory = saveDatastoreDirectory;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
        List<LoginChangeListener> listeners = this.getLoginChangeListeners();
        for (LoginChangeListener listener : listeners) {
            listener.onLoginStateChanged(this.isLoggedIn(), username);
        }
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isLoggedIn() {
        return !StringUtils.isNullOrEmpty((String)this.getUsername());
    }

    @Override
    public void addRecentJobFile(FileObject fileObject) {
        File file = VFSUtils.toFile((FileObject)fileObject);
        if (file != null) {
            if (this.recentJobFiles.contains(file)) {
                this.recentJobFiles.remove(file);
            }
            this.recentJobFiles.add(0, file);
        }
    }

    @Override
    public List<FileObject> getRecentJobFiles() {
        List fileObjectList = CollectionUtils.map(this.recentJobFiles, (Func)new Func<File, FileObject>(){

            public FileObject eval(File file) {
                try {
                    return VFSUtils.getFileSystemManager().toFileObject(file);
                }
                catch (FileSystemException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
        return fileObjectList;
    }

    @Override
    public List<Datastore> getUserDatastores() {
        if (this.userDatastores == null) {
            this.userDatastores = new ArrayList<Datastore>();
        }
        return this.userDatastores;
    }

    @Override
    public List<Dictionary> getUserDictionaries() {
        if (this.userDictionaries == null) {
            this.userDictionaries = new ArrayList<Dictionary>();
        }
        return this.userDictionaries;
    }

    @Override
    public List<SynonymCatalog> getUserSynonymCatalogs() {
        if (this.userSynonymCatalogs == null) {
            this.userSynonymCatalogs = new ArrayList<SynonymCatalog>();
        }
        return this.userSynonymCatalogs;
    }

    @Override
    public List<UserDatabaseDriver> getDatabaseDrivers() {
        if (this.databaseDrivers == null) {
            this.databaseDrivers = new ArrayList<UserDatabaseDriver>();
        }
        return this.databaseDrivers;
    }

    @Override
    public List<StringPattern> getUserStringPatterns() {
        if (this.userStringPatterns == null) {
            this.userStringPatterns = new ArrayList<StringPattern>();
        }
        return this.userStringPatterns;
    }

    @Override
    public boolean isProxyEnabled() {
        return this.proxyEnabled;
    }

    @Override
    public void setProxyEnabled(boolean proxyEnabled) {
        this.proxyEnabled = proxyEnabled;
    }

    @Override
    public String getProxyHostname() {
        return this.proxyHostname;
    }

    @Override
    public void setProxyHostname(String proxyHostname) {
        this.proxyHostname = proxyHostname;
    }

    @Override
    public int getProxyPort() {
        return this.proxyPort;
    }

    @Override
    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Override
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Override
    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    @Override
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    @Override
    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    @Override
    public boolean isProxyAuthenticationEnabled() {
        return this.proxyAuthenticationEnabled;
    }

    @Override
    public void setProxyAuthenticationEnabled(boolean proxyAuthenticationEnabled) {
        this.proxyAuthenticationEnabled = proxyAuthenticationEnabled;
    }

    @Override
    public QuickAnalysisStrategy getQuickAnalysisStrategy() {
        return this.quickAnalysisStrategy;
    }

    @Override
    public void setQuickAnalysisStrategy(QuickAnalysisStrategy quickAnalysisStrategy) {
        this.quickAnalysisStrategy = quickAnalysisStrategy;
    }

    @Override
    public List<ExtensionPackage> getExtensionPackages() {
        if (this.extensionPackages == null) {
            this.extensionPackages = new ArrayList<ExtensionPackage>();
        }
        return this.extensionPackages;
    }

    @Override
    public void setExtensionPackages(List<ExtensionPackage> extensionPackages) {
        this.extensionPackages = extensionPackages;
    }

    @Override
    public Map<String, String> getAdditionalProperties() {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, String>();
        }
        return this.additionalProperties;
    }

    @Override
    public void setMonitorConnection(MonitorConnection connection) {
        this.monitorConnection = connection;
    }

    @Override
    public MonitorConnection getMonitorConnection() {
        String hostname;
        if (this.monitorConnection == null && !StringUtils.isNullOrEmpty((String)(hostname = System.getProperty("datacleaner.monitor.hostname")))) {
            int port = Integer.parseInt(System.getProperty("datacleaner.monitor.port"));
            String contextPath = System.getProperty("datacleaner.monitor.context");
            String tenant = System.getProperty("datacleaner.monitor.tenant");
            boolean isHttps = "true".equals(System.getProperty("datacleaner.monitor.https"));
            String username = System.getProperty("datacleaner.monitor.username");
            String encodedPassword = null;
            MonitorConnection con = new MonitorConnection(hostname, port, contextPath, isHttps, tenant, username, encodedPassword);
            return con;
        }
        return this.monitorConnection;
    }

    @Override
    public File getSaveDownloadedFilesDirectory() {
        if (this.saveDownloadedFilesDirectory == null) {
            this.saveDownloadedFilesDirectory = new File(".");
        }
        return this.saveDownloadedFilesDirectory;
    }

    @Override
    public void setSaveDownloadedFilesDirectory(File directory) {
        this.saveDownloadedFilesDirectory = directory;
    }
}

