/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.util;

import java.util.Arrays;
import java.util.List;
import javax.swing.SwingWorker;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.data.ExpressionBasedInputColumn;
import org.eobjects.analyzer.data.InputColumn;
import org.eobjects.analyzer.data.InputRow;
import org.eobjects.analyzer.job.AnalysisJob;
import org.eobjects.analyzer.job.AnalyzerJob;
import org.eobjects.analyzer.job.ComponentJob;
import org.eobjects.analyzer.job.ExplorerJob;
import org.eobjects.analyzer.job.FilterJob;
import org.eobjects.analyzer.job.TransformerJob;
import org.eobjects.analyzer.job.runner.AnalysisJobMetrics;
import org.eobjects.analyzer.job.runner.AnalysisListener;
import org.eobjects.analyzer.job.runner.AnalysisResultFuture;
import org.eobjects.analyzer.job.runner.AnalysisRunner;
import org.eobjects.analyzer.job.runner.AnalysisRunnerImpl;
import org.eobjects.analyzer.job.runner.AnalyzerMetrics;
import org.eobjects.analyzer.job.runner.ExplorerMetrics;
import org.eobjects.analyzer.job.runner.RowProcessingMetrics;
import org.eobjects.analyzer.result.AnalysisResult;
import org.eobjects.analyzer.result.AnalyzerResult;
import org.eobjects.analyzer.util.LabelUtils;
import org.eobjects.analyzer.util.SourceColumnFinder;
import org.eobjects.datacleaner.panels.ProgressInformationPanel;
import org.eobjects.datacleaner.windows.ResultWindow;
import org.eobjects.metamodel.schema.Table;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnalysisRunnerSwingWorker
extends SwingWorker<AnalysisResultFuture, Void>
implements AnalysisListener {
    private static final Logger logger = LoggerFactory.getLogger(AnalysisRunnerSwingWorker.class);
    private final AnalysisRunner _analysisRunner;
    private final AnalysisJob _job;
    private final ResultWindow _resultWindow;
    private final ProgressInformationPanel _progressInformationPanel;
    private AnalysisResultFuture _resultFuture;

    public AnalysisRunnerSwingWorker(AnalyzerBeansConfiguration configuration, AnalysisJob job, ResultWindow resultWindow, ProgressInformationPanel progressInformationPanel) {
        this._analysisRunner = new AnalysisRunnerImpl(configuration, new AnalysisListener[]{this});
        this._job = job;
        this._resultWindow = resultWindow;
        this._progressInformationPanel = progressInformationPanel;
    }

    @Override
    protected AnalysisResultFuture doInBackground() throws Exception {
        try {
            this._resultFuture = this._analysisRunner.run(this._job);
            return this._resultFuture;
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred when invoking run(...) on AnalysisRunner", (Throwable)e);
            this.errorUknown(this._job, e);
            throw e;
        }
    }

    public void jobBegin(AnalysisJob job, AnalysisJobMetrics metrics) {
        String now = new DateTime().toString(DateTimeFormat.fullTime());
        this._progressInformationPanel.addUserLog("Job begin (" + now + ")");
    }

    public void jobSuccess(AnalysisJob job, AnalysisJobMetrics metrics) {
        String now = new DateTime().toString(DateTimeFormat.fullTime());
        this._progressInformationPanel.addUserLog("Job success (" + now + ")");
        this._progressInformationPanel.onSuccess();
        this._resultWindow.setResult((AnalysisResult)this._resultFuture);
    }

    public void rowProcessingBegin(AnalysisJob job, RowProcessingMetrics metrics) {
        int expectedRows = metrics.getExpectedRows();
        Table table = metrics.getTable();
        if (expectedRows == -1) {
            this._progressInformationPanel.addUserLog("Starting row processing for " + table.getQualifiedLabel());
        } else {
            this._progressInformationPanel.addUserLog("Starting row processing for " + table.getQualifiedLabel() + " (approx. " + expectedRows + " rows)");
            this._progressInformationPanel.setExpectedRows(table, expectedRows);
        }
    }

    public void rowProcessingProgress(AnalysisJob job, RowProcessingMetrics metrics, int currentRow) {
        this._progressInformationPanel.updateProgress(metrics.getTable(), currentRow);
    }

    public void rowProcessingSuccess(AnalysisJob job, RowProcessingMetrics metrics) {
        String now = new DateTime().toString(DateTimeFormat.fullTime());
        this._progressInformationPanel.addUserLog("Row processing for " + metrics.getTable().getQualifiedLabel() + " finished (" + now + "). Generating results ...");
    }

    public void analyzerBegin(AnalysisJob job, AnalyzerJob analyzerJob, AnalyzerMetrics metrics) {
        this._progressInformationPanel.addUserLog("Starting analyzer '" + LabelUtils.getLabel((ComponentJob)analyzerJob) + "'");
    }

    public void analyzerSuccess(AnalysisJob job, AnalyzerJob analyzerJob, AnalyzerResult result) {
        List<InputColumn> inputColumns = Arrays.asList(analyzerJob.getInput());
        InputColumn tableInputColumn = null;
        for (InputColumn inputColumn : inputColumns) {
            if (inputColumn instanceof ExpressionBasedInputColumn) continue;
            tableInputColumn = inputColumn;
            break;
        }
        assert (tableInputColumn != null);
        SourceColumnFinder sourceColumnFinder = new SourceColumnFinder();
        sourceColumnFinder.addSources(job);
        Table table = sourceColumnFinder.findOriginatingTable(tableInputColumn);
        this._progressInformationPanel.addUserLog("Analyzer '" + LabelUtils.getLabel((ComponentJob)analyzerJob) + "' finished");
        this._progressInformationPanel.addUserLog("Adding result to tab of " + table.getName());
        this._resultWindow.addResult(table, (ComponentJob)analyzerJob, result);
    }

    public void errorInFilter(AnalysisJob job, FilterJob filterJob, InputRow row, Throwable throwable) {
        this._progressInformationPanel.addUserLog("An error occurred in the filter: " + LabelUtils.getLabel((ComponentJob)filterJob), throwable, true);
    }

    public void errorInTransformer(AnalysisJob job, TransformerJob transformerJob, InputRow row, Throwable throwable) {
        this._progressInformationPanel.addUserLog("An error occurred in the transformer: " + LabelUtils.getLabel((ComponentJob)transformerJob), throwable, true);
    }

    public void errorInAnalyzer(AnalysisJob job, AnalyzerJob analyzerJob, InputRow row, Throwable throwable) {
        this._progressInformationPanel.addUserLog("An error occurred in the analyzer: " + LabelUtils.getLabel((ComponentJob)analyzerJob), throwable, true);
    }

    public void errorUknown(AnalysisJob job, Throwable throwable) {
        this._progressInformationPanel.addUserLog("An error occurred in the analysis job!", throwable, true);
    }

    public void cancelIfRunning() {
        if (this._resultFuture != null && !this._resultFuture.isDone()) {
            this._resultFuture.cancel();
        }
    }

    public void explorerBegin(AnalysisJob job, ExplorerJob explorerJob, ExplorerMetrics metrics) {
        this._progressInformationPanel.addUserLog("Starting explorer '" + LabelUtils.getLabel((ComponentJob)explorerJob) + "'");
    }

    public void explorerSuccess(AnalysisJob job, ExplorerJob explorerJob, AnalyzerResult result) {
        this._progressInformationPanel.addUserLog("Explorer '" + LabelUtils.getLabel((ComponentJob)explorerJob) + "' finished");
        this._progressInformationPanel.addUserLog("Adding result to tab of " + explorerJob.getDescriptor().getDisplayName());
        this._resultWindow.addResult((ComponentJob)explorerJob, result);
    }

    public void errorInExplorer(AnalysisJob job, ExplorerJob explorerJob, Throwable throwable) {
        this._progressInformationPanel.addUserLog("An error occurred in the explorer: " + LabelUtils.getLabel((ComponentJob)explorerJob), throwable, true);
    }
}

