/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.util;

import javax.swing.SwingUtilities;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DCUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(DCUncaughtExceptionHandler.class);

    @Override
    public void uncaughtException(Thread t, final Throwable e) {
        logger.error("Thread " + t.getName() + " threw uncaught exception", e);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WidgetUtils.showErrorMessage("Unexpected error!", e);
            }
        });
    }
}

