/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.util;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;

public class ExtensionFilter
extends FileFilter
implements FilenameFilter {
    private final String _desc;
    private final String _extension;

    public ExtensionFilter(String desc, String extension) {
        this._desc = desc;
        this._extension = extension.toLowerCase();
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String fileName = f.getAbsolutePath();
        if (fileName.length() < this._extension.length()) {
            return false;
        }
        return this.accept(null, fileName);
    }

    @Override
    public boolean accept(File dir, String name) {
        String extension = name.substring(name.length() - this._extension.length());
        return extension.equalsIgnoreCase(this._extension);
    }

    @Override
    public String getDescription() {
        return this._desc;
    }

    public String getExtension() {
        return this._extension;
    }
}

