/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.util;

import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.eobjects.analyzer.util.CollectionUtils2;
import org.eobjects.datacleaner.util.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageManager {
    private static final Logger logger = LoggerFactory.getLogger(ImageManager.class);
    private static ImageManager instance = new ImageManager();
    private final Map<String, Image> _cachedImageIcons = CollectionUtils2.createCacheMap();
    private final ResourceManager resourceManager = ResourceManager.getInstance();

    public static ImageManager getInstance() {
        return instance;
    }

    private ImageManager() {
    }

    public ImageIcon getImageIcon(String imagePath, ClassLoader ... classLoaders) {
        if (imagePath.endsWith(".gif")) {
            URL url = this.resourceManager.getUrl(imagePath, classLoaders);
            return new ImageIcon(url);
        }
        return new ImageIcon(this.getImage(imagePath, classLoaders));
    }

    public ImageIcon getImageIcon(String imagePath, int newWidth, ClassLoader ... classLoaders) {
        return new ImageIcon(this.getImage(imagePath, newWidth, classLoaders));
    }

    public Image getImage(String imagePath, ClassLoader ... classLoaders) {
        Image image = this._cachedImageIcons.get(imagePath);
        if (image == null) {
            URL url = this.resourceManager.getUrl(imagePath, classLoaders);
            if (url == null) {
                logger.warn("Image path ({}) could not be resolved", (Object)imagePath);
            } else {
                logger.debug("Image path ({}) resolved to url: {}", (Object)imagePath, (Object)url);
            }
            try {
                image = ImageIO.read(url);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not read image from url:" + url);
            }
            if (image == null) {
                throw new IllegalArgumentException("Could not read image: " + imagePath + " (url: " + url + ")");
            }
        }
        return image;
    }

    public Image getImage(String imagePath, int newWidth, ClassLoader ... classLoaders) {
        Image image = this._cachedImageIcons.get(imagePath + ",width=" + newWidth);
        if (image == null) {
            image = this.getImage(imagePath, classLoaders);
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            if (width > newWidth) {
                int newHeight = newWidth * height / width;
                image = image.getScaledInstance(newWidth, newHeight, 4);
                this._cachedImageIcons.put(imagePath + ",width=" + newWidth, image);
            }
        }
        return image;
    }
}

