/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.util;

import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import java.util.Set;
import javax.swing.LookAndFeel;
import javax.swing.PopupFactory;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.tooltip.DCPopupFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LookAndFeelManager {
    private static final Logger logger = LoggerFactory.getLogger(LookAndFeelManager.class);
    private static final LookAndFeelManager instance = new LookAndFeelManager();
    private static final ImageManager imageManager = ImageManager.getInstance();

    public static LookAndFeelManager getInstance() {
        return instance;
    }

    private LookAndFeelManager() {
    }

    public void init() {
        try {
            PlasticXPLookAndFeel laf = new PlasticXPLookAndFeel();
            UIManager.setLookAndFeel((LookAndFeel)laf);
            logger.info("Look and feel set to: {}", (Object)UIManager.getLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            throw new IllegalStateException(e);
        }
        Set propertyKeys = UIManager.getLookAndFeelDefaults().keySet();
        for (Object propertyKey : propertyKeys) {
            if (!(propertyKey instanceof String)) continue;
            String str = (String)propertyKey;
            if (str.endsWith(".font")) {
                UIManager.put(propertyKey, WidgetUtils.FONT_NORMAL);
                continue;
            }
            if (!str.endsWith(".background")) continue;
            UIManager.put(propertyKey, WidgetUtils.BG_COLOR_BRIGHT);
        }
        ToolTipManager.sharedInstance().setInitialDelay(500);
        PopupFactory.setSharedInstance(new DCPopupFactory());
        EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
        LineBorder borderDarkest3 = new LineBorder(WidgetUtils.BG_COLOR_DARKEST, 3);
        UIManager.put("ScrollPane.border", emptyBorder);
        UIManager.put("Menu.border", borderDarkest3);
        UIManager.put("Menu.background", WidgetUtils.BG_COLOR_DARKEST);
        UIManager.put("Menu.foreground", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("MenuItem.selectionForeground", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("MenuItem.selectionBackground", WidgetUtils.BG_COLOR_LESS_DARK);
        UIManager.put("List.selectionForeground", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("List.selectionBackground", WidgetUtils.BG_COLOR_LESS_DARK);
        UIManager.put("List.focusCellHighlightBorder", WidgetUtils.BORDER_THIN);
        UIManager.put("Tree.selectionForeground", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("Tree.selectionBackground", WidgetUtils.BG_COLOR_LESS_DARK);
        UIManager.put("Tree.selectionBorderColor", WidgetUtils.BG_COLOR_MEDIUM);
        UIManager.put("Table.selectionForeground", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("Table.selectionBackground", WidgetUtils.BG_COLOR_LESS_DARK);
        UIManager.put("Table.focusCellHighlightBorder", WidgetUtils.BORDER_THIN);
        UIManager.put("SplitPane.border", new EmptyBorder(0, 0, 0, 0));
        UIManager.put("SplitPaneDivider.border", new EmptyBorder(0, 0, 0, 0));
        UIManager.put("PopupMenu.border", emptyBorder);
        UIManager.put("PopupMenu.background", WidgetUtils.BG_COLOR_DARKEST);
        UIManager.put("PopupMenu.foreground", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("MenuItem.border", borderDarkest3);
        UIManager.put("MenuItem.background", WidgetUtils.BG_COLOR_DARKEST);
        UIManager.put("MenuItem.foreground", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("MenuBar.border", emptyBorder);
        UIManager.put("MenuBar.background", WidgetUtils.BG_COLOR_DARKEST);
        UIManager.put("MenuBar.foreground", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("Tree.background", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("TextArea.background", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("PasswordField.background", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("FormattedTextField.background", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("EditorPane.background", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("ComboBox.background", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("TextField.background", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("Spinner.background", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("TableHeader.background", WidgetUtils.BG_COLOR_DARK);
        UIManager.put("TableHeader.focusCellBackground", WidgetUtils.BG_COLOR_LESS_DARK);
        UIManager.put("TableHeader.foreground", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("TableHeader.cellBorder", new LineBorder(WidgetUtils.BG_COLOR_LESS_DARK));
        UIManager.put("TitledBorder.font", WidgetUtils.FONT_HEADER1);
        UIManager.put("TitledBorder.titleColor", WidgetUtils.BG_COLOR_BLUE_BRIGHT);
        UIManager.put("ToolTip.background", WidgetUtils.BG_COLOR_DARK);
        UIManager.put("ToolTip.foreground", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("ToolTip.border", WidgetUtils.BORDER_THIN);
        UIManager.put("TaskPane.font", WidgetUtils.FONT_NORMAL);
        UIManager.put("TaskPaneContainer.background", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("TaskPane.titleForeground", WidgetUtils.BG_COLOR_BRIGHTEST);
        UIManager.put("TaskPane.titleBackgroundGradientStart", WidgetUtils.BG_COLOR_DARKEST);
        UIManager.put("TaskPane.titleBackgroundGradientEnd", WidgetUtils.BG_COLOR_DARKEST);
        UIManager.put("TaskPane.borderColor", WidgetUtils.BG_COLOR_DARKEST);
        UIManager.put("TaskPane.background", WidgetUtils.BG_COLOR_BRIGHT);
        UIManager.put("ScrollBar.thumb", WidgetUtils.BG_COLOR_DARK);
        UIManager.put("ScrollBar.thumbHighlight", WidgetUtils.BG_COLOR_DARK);
        UIManager.put("ScrollBar.thumbShadow", WidgetUtils.BG_COLOR_DARK);
        UIManager.put("ProgressBar.foreground", WidgetUtils.BG_COLOR_BLUE_BRIGHT);
        UIManager.put("FileChooser.detailsViewIcon", imageManager.getImageIcon("images/filetypes/view-details.png", new ClassLoader[0]));
        UIManager.put("FileChooser.listViewIcon", imageManager.getImageIcon("images/filetypes/view-list.png", new ClassLoader[0]));
        UIManager.put("FileChooser.homeFolderIcon", imageManager.getImageIcon("images/filetypes/home-folder.png", new ClassLoader[0]));
        UIManager.put("FileChooser.newFolderIcon", imageManager.getImageIcon("images/filetypes/new-folder.png", new ClassLoader[0]));
        UIManager.put("FileChooser.upFolderIcon", imageManager.getImageIcon("images/filetypes/parent-folder.png", new ClassLoader[0]));
        UIManager.put("JXMonthView.foreground", WidgetUtils.BG_COLOR_DARK);
        UIManager.put("JXMonthView.monthStringForeground", WidgetUtils.BG_COLOR_DARK);
        UIManager.put("JXMonthView.daysOfTheWeekForeground", WidgetUtils.BG_COLOR_DARK);
        UIManager.put("JXMonthView.weekOfTheYearForeground", WidgetUtils.BG_COLOR_DARK);
        UIManager.put("JXMonthView.unselectableDayForeground", WidgetUtils.BG_COLOR_MEDIUM);
    }
}

