/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.util;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.eobjects.analyzer.util.CharIterator;

public class NumberDocument
extends PlainDocument {
    private static final long serialVersionUID = 1L;
    private final boolean _allowDecimal;
    private final boolean _allowNegative;

    public NumberDocument() {
        this(true);
    }

    public NumberDocument(boolean allowDecimal) {
        this(allowDecimal, true);
    }

    public NumberDocument(boolean allowDecimal, boolean allowNegative) {
        this._allowDecimal = allowDecimal;
        this._allowNegative = allowNegative;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        boolean valid = true;
        CharIterator it = new CharIterator((CharSequence)str);
        while (it.hasNext() && valid) {
            it.next();
            if (it.isDigit() || it.is(Character.valueOf('%')) || it.is(Character.valueOf('-')) && this._allowNegative || it.is(Character.valueOf('.')) && this._allowDecimal) continue;
            valid = false;
            break;
        }
        if (valid) {
            super.insertString(offs, str, a);
        }
    }
}

