/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.JTextComponent;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.ResourceManager;
import org.eobjects.metamodel.util.FileHelper;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.border.DropShadowBorder;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WidgetUtils {
    private static final Logger logger;
    public static final float FONT_SIZE_SMALL = 11.0f;
    private static final Map<String, Font> fonts;
    public static final Font FONT_UBUNTU_PLAIN;
    public static final Font FONT_UBUNTU_BOLD;
    public static final Font FONT_UBUNTU_ITALIC;
    public static final Font FONT_UBUNTU_BOLD_ITALIC;
    public static final Font FONT_OPENSANS_PLAIN;
    public static final Font FONT_OPENSANS_BOLD;
    public static final Font FONT_OPENSANS_ITALIC;
    public static final Font FONT_OPENSANS_BOLD_ITALIC;
    public static final Font FONT_BANNER;
    public static final Font FONT_HEADER1;
    public static final Font FONT_HEADER2;
    public static final Font FONT_MONOSPACE;
    public static final Font FONT_NORMAL;
    public static final Font FONT_SMALL;
    public static final Color BG_COLOR_BLUE_BRIGHT;
    public static final Color BG_COLOR_BLUE_MEDIUM;
    public static final Color BG_COLOR_BLUE_DARK;
    public static final Color BG_COLOR_ORANGE_BRIGHT;
    public static final Color BG_COLOR_ORANGE_MEDIUM;
    public static final Color BG_COLOR_ORANGE_DARK;
    public static final Color BG_COLOR_PALE_YELLOW;
    public static final Color BG_COLOR_BRIGHTEST;
    public static final Color BG_COLOR_BRIGHT;
    public static final Color BG_COLOR_LESS_BRIGHT;
    public static final Color BG_COLOR_MEDIUM;
    public static final Color BG_COLOR_LESS_DARK;
    public static final Color BG_COLOR_DARK;
    public static final Color BG_COLOR_DARKEST;
    public static final Color ADDITIONAL_COLOR_GREEN_BRIGHT;
    public static final Color ADDITIONAL_COLOR_RED_BRIGHT;
    public static final Color ADDITIONAL_COLOR_PURPLE_BRIGHT;
    public static final Color ADDITIONAL_COLOR_CYAN_BRIGHT;
    public static final int BORDER_WIDE_WIDTH = 4;
    public static final Border BORDER_SHADOW;
    public static final Border BORDER_WIDE;
    public static final Border BORDER_EMPTY;
    public static Border BORDER_TOP_PADDING;
    public static final Border BORDER_THIN;
    public static final Border BORDER_LIST_ITEM;
    public static final Border BORDER_EMPHASIZE_FIELD;
    public static final Highlighter LIBERELLO_HIGHLIGHTER;
    private static final double COLOR_SCALE_FACTOR = 0.9;
    public static final int DEFAULT_PADDING = 2;
    public static final int DEFAULT_ANCHOR = 18;

    private WidgetUtils() {
    }

    private static Font createFont(String path) {
        Font font;
        URL url = ResourceManager.getInstance().getUrl(path, new ClassLoader[0]);
        if (url == null) {
            throw new IllegalArgumentException("Font resource not found: " + path);
        }
        InputStream in = null;
        try {
            in = url.openStream();
            font = Font.createFont(0, in);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{in});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{in});
        return font;
    }

    public static void centerOnScreen(Component component) {
        Dimension paneSize = component.getSize();
        Dimension screenSize = component.getToolkit().getScreenSize();
        component.setLocation((screenSize.width - paneSize.width) / 2, (screenSize.height - paneSize.height) / 2);
    }

    public static void addToGridBag(Component comp, JPanel panel, int gridx, int gridy, int width, int height, int anchor) {
        WidgetUtils.addToGridBag(comp, panel, gridx, gridy, width, height, anchor, 2);
    }

    public static void addToGridBag(Component comp, JPanel panel, int gridx, int gridy, int width, int height, int anchor, int padding) {
        WidgetUtils.addToGridBag(comp, panel, gridx, gridy, width, height, anchor, padding, 0.0, 0.0);
    }

    public static void addToGridBag(Component comp, JPanel panel, int gridx, int gridy, int width, int height, int anchor, int padding, double weightx, double weighty) {
        LayoutManager layout = panel.getLayout();
        if (!(layout instanceof GridBagLayout)) {
            layout = new GridBagLayout();
            panel.setLayout(layout);
        }
        GridBagLayout gridBagLayout = (GridBagLayout)layout;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        constraints.anchor = anchor;
        constraints.fill = 2;
        constraints.insets = new Insets(padding, padding, padding, padding);
        gridBagLayout.addLayoutComponent(comp, constraints);
        panel.add(comp);
    }

    public static void addToGridBag(Component comp, JPanel panel, int gridx, int gridy, int width, int height) {
        WidgetUtils.addToGridBag(comp, panel, gridx, gridy, width, height, 18);
    }

    public static void addToGridBag(Component comp, JPanel panel, int x, int y, int anchor, double weightx, double weighty) {
        WidgetUtils.addToGridBag(comp, panel, x, y, 1, 1, anchor, 2, weightx, weighty);
    }

    public static void addToGridBag(Component comp, JPanel panel, int gridx, int gridy) {
        WidgetUtils.addToGridBag(comp, panel, gridx, gridy, 1, 1);
    }

    public static void addToGridBag(Component comp, JPanel panel, int gridx, int gridy, double weightx, double weighty) {
        WidgetUtils.addToGridBag(comp, panel, gridx, gridy, 1, 1, 18, 2, weightx, weighty);
    }

    public static void addToGridBag(Component comp, JPanel panel, int gridx, int gridy, int anchor) {
        WidgetUtils.addToGridBag(comp, panel, gridx, gridy, 1, 1, anchor);
    }

    public static void addAligned(Container container, JComponent component) {
        component.setAlignmentX(0.0f);
        component.setAlignmentY(0.0f);
        container.add(component);
    }

    public static void showErrorMessage(String shortMessage, String detailedMessage, Throwable exception) {
        JXErrorPane.setDefaultLocale((Locale)Locale.ENGLISH);
        JXErrorPane errorPane = new JXErrorPane();
        String finalDetailedMessage = detailedMessage == null ? "" : detailedMessage;
        String finalShortMessage = shortMessage == null ? "" : shortMessage;
        ErrorInfo info = new ErrorInfo(finalShortMessage, finalDetailedMessage, null, "error", exception, ErrorLevel.SEVERE, null);
        errorPane.setErrorInfo(info);
        JDialog dialog = JXErrorPane.createDialog(null, (JXErrorPane)errorPane);
        WidgetUtils.centerOnScreen(dialog);
        dialog.setLocale(Locale.ENGLISH);
        dialog.setModal(true);
        dialog.setTitle(finalShortMessage);
        dialog.setVisible(true);
        dialog.toFront();
    }

    public static void showErrorMessage(String shortMessage, Throwable exception) {
        StringBuilder sb = new StringBuilder();
        for (Throwable e = exception; e != null; e = e.getCause()) {
            if (sb.length() != 0) {
                sb.append("\n\n");
            }
            String message = e.getMessage();
            sb.append(message);
        }
        WidgetUtils.showErrorMessage(shortMessage, sb.toString(), exception);
    }

    public static JScrollPane scrolleable(JComponent comp) {
        JScrollPane scroll = new JScrollPane();
        if (comp != null) {
            scroll.setViewportView(comp);
        }
        scroll.setOpaque(false);
        scroll.getViewport().setOpaque(false);
        return scroll;
    }

    public static Color colorBetween(Color c1, Color c2) {
        int red = (c1.getRed() + c2.getRed()) / 2;
        int green = (c1.getGreen() + c2.getGreen()) / 2;
        int blue = (c1.getBlue() + c2.getBlue()) / 2;
        return new Color(red, green, blue);
    }

    public static Color slightlyDarker(Color color) {
        return new Color(Math.max((int)((double)color.getRed() * 0.9), 0), Math.max((int)((double)color.getGreen() * 0.9), 0), Math.max((int)((double)color.getBlue() * 0.9), 0));
    }

    public static Color slightlyBrighter(Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        int i = 10;
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / 0.9), 255), Math.min((int)((double)g / 0.9), 255), Math.min((int)((double)b / 0.9), 255));
    }

    public static String extractText(Component comp) {
        if (comp instanceof JLabel) {
            return ((JLabel)comp).getText();
        }
        if (comp instanceof JTextComponent) {
            return ((JTextComponent)comp).getText();
        }
        if (comp instanceof Container) {
            Component[] children = ((Container)comp).getComponents();
            StringBuilder sb = new StringBuilder();
            for (Component child : children) {
                String text = WidgetUtils.extractText(child);
                if (StringUtils.isNullOrEmpty((String)text)) continue;
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(text);
            }
            return sb.toString();
        }
        logger.warn("Could not extract text from component: {}", (Object)comp);
        return "";
    }

    public static DCPanel decorateWithShadow(JComponent comp, boolean outline, int margin) {
        DCPanel panel = new DCPanel();
        panel.setLayout(new BorderLayout());
        Border border = BORDER_SHADOW;
        if (outline) {
            border = new CompoundBorder(border, BORDER_THIN);
        }
        if (margin > 0) {
            border = new CompoundBorder(new EmptyBorder(margin, margin, margin, margin), border);
        }
        panel.setBorder(border);
        panel.add((Component)comp, "Center");
        return panel;
    }

    public static Font findCompatibleFont(String text, Font fallbackFont) {
        String[] searchFonts;
        for (String fontName : searchFonts = new String[]{"SansSerif", "Serif", "Verdana", "Arial Unicode MS", "MS UI Gothic", "MS Mincho", "MS Gothic", "Osaka"}) {
            Font font = fonts.get(fontName);
            if (font == null) {
                font = new Font(fontName, fallbackFont.getStyle(), fallbackFont.getSize());
            }
            if (font.canDisplayUpTo(text) != -1) continue;
            logger.info("Font '{}' was capable, returning", (Object)fontName);
            font = font.deriveFont(fallbackFont.getSize2D());
            return font;
        }
        logger.warn("Didn't find any capable fonts for text '{}'", (Object)text);
        return fallbackFont;
    }

    public static void setAppropriateFont(JLabel label) {
        String text = label.getText();
        if (text == null) {
            return;
        }
        Font font = label.getFont();
        int canDisplay = font.canDisplayUpTo(text);
        if (canDisplay != -1) {
            logger.warn("Default font ('{}') was unable to display text ('{}'), searching for alternative.", (Object)font.getName(), (Object)text);
            font = WidgetUtils.findCompatibleFont(text, font);
            label.setFont(font);
        }
    }

    static {
        Font[] fontArray;
        logger = LoggerFactory.getLogger(WidgetUtils.class);
        fonts = new HashMap<String, Font>();
        for (Font font : fontArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            if (!font.isPlain()) continue;
            fonts.put(font.getName(), font);
        }
        FONT_UBUNTU_PLAIN = WidgetUtils.createFont("fonts/Ubuntu-R.ttf");
        FONT_UBUNTU_ITALIC = WidgetUtils.createFont("fonts/Ubuntu-RI.ttf");
        FONT_UBUNTU_BOLD = WidgetUtils.createFont("fonts/Ubuntu-B.ttf");
        FONT_UBUNTU_BOLD_ITALIC = WidgetUtils.createFont("fonts/Ubuntu-BI.ttf");
        FONT_OPENSANS_PLAIN = WidgetUtils.createFont("fonts/OpenSans-Regular.ttf");
        FONT_OPENSANS_ITALIC = WidgetUtils.createFont("fonts/OpenSans-Italic.ttf");
        FONT_OPENSANS_BOLD = WidgetUtils.createFont("fonts/OpenSans-Bold.ttf");
        FONT_OPENSANS_BOLD_ITALIC = WidgetUtils.createFont("fonts/OpenSans-BoldItalic.ttf");
        fonts.put(FONT_UBUNTU_PLAIN.getName(), FONT_UBUNTU_PLAIN);
        fonts.put(FONT_OPENSANS_PLAIN.getName(), FONT_OPENSANS_PLAIN);
        FONT_BANNER = FONT_UBUNTU_PLAIN.deriveFont(18.0f);
        FONT_HEADER1 = FONT_UBUNTU_PLAIN.deriveFont(15.0f);
        FONT_HEADER2 = FONT_UBUNTU_PLAIN.deriveFont(13.0f);
        FONT_MONOSPACE = new FontUIResource("Monospaced", 0, 14);
        FONT_NORMAL = FONT_OPENSANS_PLAIN.deriveFont(13.0f);
        FONT_SMALL = FONT_OPENSANS_PLAIN.deriveFont(11.0f);
        BG_COLOR_BLUE_BRIGHT = new ColorUIResource(85, 148, 221);
        BG_COLOR_BLUE_MEDIUM = new ColorUIResource(35, 93, 160);
        BG_COLOR_BLUE_DARK = new ColorUIResource(2, 58, 124);
        BG_COLOR_ORANGE_BRIGHT = new ColorUIResource(255, 168, 0);
        BG_COLOR_ORANGE_MEDIUM = new ColorUIResource(225, 102, 5);
        BG_COLOR_ORANGE_DARK = new ColorUIResource(168, 99, 15);
        BG_COLOR_PALE_YELLOW = new ColorUIResource(244, 244, 211);
        BG_COLOR_BRIGHTEST = ColorUIResource.WHITE;
        BG_COLOR_BRIGHT = new ColorUIResource(235, 235, 235);
        BG_COLOR_LESS_BRIGHT = new ColorUIResource(220, 220, 220);
        BG_COLOR_MEDIUM = new ColorUIResource(160, 160, 160);
        BG_COLOR_LESS_DARK = new ColorUIResource(95, 95, 95);
        BG_COLOR_DARK = new ColorUIResource(70, 70, 70);
        BG_COLOR_DARKEST = new ColorUIResource(40, 40, 40);
        ADDITIONAL_COLOR_GREEN_BRIGHT = new ColorUIResource(123, 207, 38);
        ADDITIONAL_COLOR_RED_BRIGHT = new ColorUIResource(211, 36, 36);
        ADDITIONAL_COLOR_PURPLE_BRIGHT = new ColorUIResource(211, 36, 156);
        ADDITIONAL_COLOR_CYAN_BRIGHT = new ColorUIResource(36, 209, 211);
        BORDER_SHADOW = new DropShadowBorder(BG_COLOR_DARK, 6);
        BORDER_WIDE = new LineBorder(BG_COLOR_DARK, 4);
        BORDER_EMPTY = new EmptyBorder(4, 4, 4, 4);
        BORDER_TOP_PADDING = new EmptyBorder(10, 0, 0, 0);
        BORDER_THIN = new LineBorder(BG_COLOR_MEDIUM);
        BORDER_LIST_ITEM = new MatteBorder(0, 2, 1, 0, BG_COLOR_MEDIUM);
        BORDER_EMPHASIZE_FIELD = new LineBorder(ADDITIONAL_COLOR_RED_BRIGHT, 2, false);
        LIBERELLO_HIGHLIGHTER = HighlighterFactory.createAlternateStriping((Color)WidgetUtils.colorBetween(BG_COLOR_BRIGHTEST, BG_COLOR_BRIGHT), (Color)BG_COLOR_BRIGHTEST);
    }
}

