/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.eobjects.analyzer.descriptors.FilterBeanDescriptor;
import org.eobjects.analyzer.job.ComponentJob;
import org.eobjects.analyzer.job.FilterJob;
import org.eobjects.analyzer.job.FilterOutcome;
import org.eobjects.analyzer.job.MergedOutcome;
import org.eobjects.analyzer.job.MergedOutcomeJob;
import org.eobjects.analyzer.job.Outcome;
import org.eobjects.analyzer.job.OutcomeSourceJob;
import org.eobjects.analyzer.job.builder.AbstractBeanJobBuilder;
import org.eobjects.analyzer.job.builder.AbstractBeanWithInputColumnsBuilder;
import org.eobjects.analyzer.job.builder.FilterJobBuilder;
import org.eobjects.analyzer.job.builder.LazyFilterOutcome;
import org.eobjects.analyzer.util.LabelUtils;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeRequirementButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ChangeRequirementButton.class);
    private static final String NO_FILTER_TEXT = "(No filter requirement)";
    private static final ImageManager imageManager = ImageManager.getInstance();
    private static final Icon mappedFilterIcon = imageManager.getImageIcon("images/status/valid.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
    private static final Icon unconfiguredFilterIcon = imageManager.getImageIcon("images/status/warning.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
    private final AbstractBeanWithInputColumnsBuilder<?, ?, ?> _jobBuilder;

    public ChangeRequirementButton(AbstractBeanWithInputColumnsBuilder<?, ?, ?> jobBuilder) {
        super(NO_FILTER_TEXT, ImageManager.getInstance().getImageIcon("images/component-types/filter.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
        this._jobBuilder = jobBuilder;
        this.addActionListener(this);
        this.updateText();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Outcome currentRequirement = this._jobBuilder.getRequirement();
        logger.info("Current requirement: {}", (Object)currentRequirement);
        JPopupMenu popup = new JPopupMenu();
        JMenuItem noFilterMenuItem = new JMenuItem(NO_FILTER_TEXT);
        noFilterMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangeRequirementButton.this._jobBuilder.setRequirement(null);
                ChangeRequirementButton.this.updateText();
            }
        });
        popup.add(noFilterMenuItem);
        LinkedList fjbs = this._jobBuilder.getAnalysisJobBuilder().getFilterJobBuilders();
        if (this._jobBuilder instanceof FilterJobBuilder) {
            fjbs = new LinkedList(fjbs);
            fjbs.remove(this._jobBuilder);
        }
        for (final FilterJobBuilder fjb : fjbs) {
            JMenu filterMenuItem = new JMenu(LabelUtils.getLabel((AbstractBeanJobBuilder)fjb));
            if (!fjb.isConfigured()) {
                filterMenuItem.setIcon(unconfiguredFilterIcon);
                filterMenuItem.setEnabled(false);
                filterMenuItem.setToolTipText("Filter is not correctly configured");
            } else if (!this._jobBuilder.validateRequirementSource((OutcomeSourceJob)fjb)) {
                filterMenuItem.setEnabled(false);
                filterMenuItem.setToolTipText("Requirement not possible");
            } else {
                FilterBeanDescriptor fjbDescriptor = (FilterBeanDescriptor)fjb.getDescriptor();
                Set categoryNames = fjbDescriptor.getOutcomeCategoryNames();
                for (final String category : categoryNames) {
                    JMenuItem categoryMenuItem = new JMenuItem(category);
                    if (currentRequirement != null && currentRequirement instanceof FilterOutcome) {
                        FilterOutcome filterOutcome = (FilterOutcome)currentRequirement;
                        try {
                            FilterJob filterJob = fjb.toFilterJob();
                            if (filterOutcome.getFilterJob().equals(filterJob) && filterOutcome.getCategory().equals(fjbDescriptor.getOutcomeCategoryByName(category))) {
                                filterMenuItem.setIcon(mappedFilterIcon);
                                categoryMenuItem.setIcon(mappedFilterIcon);
                            }
                        }
                        catch (Exception ex) {
                            System.out.println("ex: " + ex.getMessage());
                            logger.warn("Filterjob matching threw exception, probably because of incomplete configuration", (Throwable)ex);
                        }
                    }
                    categoryMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ChangeRequirementButton.this._jobBuilder.setRequirement(fjb, category);
                            ChangeRequirementButton.this.updateText();
                        }
                    });
                    filterMenuItem.add(categoryMenuItem);
                }
            }
            popup.add(filterMenuItem);
        }
        popup.show(this, 0, this.getHeight());
    }

    public void updateText() {
        logger.info("updateText()");
        Outcome requirement = this._jobBuilder.getRequirement();
        if (requirement == null) {
            this.setText(NO_FILTER_TEXT);
        } else if (requirement instanceof FilterOutcome) {
            FilterOutcome filterOutcome = (FilterOutcome)requirement;
            Enum category = filterOutcome.getCategory();
            if (filterOutcome instanceof LazyFilterOutcome) {
                FilterJobBuilder fjb = ((LazyFilterOutcome)filterOutcome).getFilterJobBuilder();
                String filterLabel = LabelUtils.getLabel((AbstractBeanJobBuilder)fjb);
                this.setText(filterLabel + ": " + category);
            } else {
                FilterJob filterJob = filterOutcome.getFilterJob();
                this.setText(LabelUtils.getLabel((ComponentJob)filterJob) + ": " + category);
            }
        } else if (requirement instanceof MergedOutcome) {
            MergedOutcomeJob job = ((MergedOutcome)requirement).getMergedOutcomeJob();
            this.setText(LabelUtils.getLabel((ComponentJob)job));
        } else {
            this.setText(requirement.toString());
        }
        this.updateParentUI();
    }

    protected void updateParentUI() {
        Container nextParent;
        Container parent = this.getParent();
        while (parent != null && (nextParent = parent.getParent()) != null && nextParent instanceof JComponent) {
            parent = nextParent;
        }
        if (parent instanceof JComponent) {
            ((JComponent)parent).updateUI();
        }
    }
}

