/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.eobjects.datacleaner.widgets.DCComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharSetEncodingComboBox
extends DCComboBox<String> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger;
    private static final String[] encodings;

    public CharSetEncodingComboBox() {
        super(encodings);
        this.setEditable(true);
        String defaultCharset = Charset.defaultCharset().name();
        this.setSelectedItem(defaultCharset);
    }

    public String autoDetectEncoding(byte[] bytes) {
        CharsetDetector cd = new CharsetDetector();
        cd.setText(bytes);
        CharsetMatch charsetMatch = cd.detect();
        String charSet = charsetMatch.getName();
        int confidence = charsetMatch.getConfidence();
        logger.info("CharsetMatch: {} ({}% confidence)", (Object)charSet, (Object)confidence);
        this.setSelectedItem(charSet);
        return charSet;
    }

    static {
        int i;
        logger = LoggerFactory.getLogger(CharSetEncodingComboBox.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add("UTF-8");
        list.add("UTF-16");
        list.add("UTF-16BE");
        list.add("UTF-16LE");
        list.add("ASCII");
        for (i = 1; i <= 16; ++i) {
            list.add("ISO-8859-" + i);
        }
        for (i = 1250; i <= 1258; ++i) {
            list.add("Windows-" + i);
        }
        encodings = list.toArray(new String[list.size()]);
    }
}

