/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.awt.LayoutManager;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.DCDocumentListener;
import org.eobjects.datacleaner.util.SingleCharacterDocument;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.jdesktop.swingx.HorizontalLayout;

public class CharTextField
extends DCPanel {
    private static final long serialVersionUID = 1L;
    private final JTextField _textField = new JTextField(2);
    private final DCLabel _label;

    public CharTextField() {
        this._textField.setDocument(new SingleCharacterDocument());
        this._label = DCLabel.dark("");
        this.addDocumentListener(new DCDocumentListener(){

            @Override
            protected void onChange(DocumentEvent e) {
                Character value = CharTextField.this.getValue();
                if (value == null) {
                    CharTextField.this._label.setText("");
                } else {
                    char c = value.charValue();
                    if (c == ' ') {
                        CharTextField.this._label.setText("[whitespace]");
                    } else if (c == '\t') {
                        CharTextField.this._label.setText("[tab]");
                    } else if (c == '\n') {
                        CharTextField.this._label.setText("[newline]");
                    } else if (c == '\r') {
                        CharTextField.this._label.setText("[carriage return]");
                    } else if (c == '\f') {
                        CharTextField.this._label.setText("[form feed]");
                    } else if (c == '\b') {
                        CharTextField.this._label.setText("[backspace]");
                    } else {
                        CharTextField.this._label.setText(value.toString());
                    }
                }
            }
        });
        this.setLayout((LayoutManager)new HorizontalLayout(2));
        this.add(this._textField);
        this.add(this._label);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this._textField.getDocument().addDocumentListener(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this._textField.getDocument().removeDocumentListener(documentListener);
    }

    public void setValue(Character value) {
        if (value == null) {
            this._textField.setText("");
        } else {
            char c = value.charValue();
            if ('\t' == c) {
                this._textField.setText("\\t");
            } else if ('\n' == c) {
                this._textField.setText("\\n");
            } else if ('\r' == c) {
                this._textField.setText("\\r");
            } else if ('\f' == c) {
                this._textField.setText("\\f");
            } else if ('\b' == c) {
                this._textField.setText("\\b");
            } else {
                this._textField.setText(value.toString());
            }
        }
    }

    public Character getValue() {
        String text = this._textField.getText();
        if (text == null || text.length() == 0) {
            return null;
        }
        if ("\\t".equals(text)) {
            return Character.valueOf('\t');
        }
        if ("\\n".equals(text)) {
            return Character.valueOf('\n');
        }
        if ("\\r".equals(text)) {
            return Character.valueOf('\r');
        }
        if ("\\f".equals(text)) {
            return Character.valueOf('\f');
        }
        if ("\\b".equals(text)) {
            return Character.valueOf('\b');
        }
        if (text.length() == 2) {
            return Character.valueOf(text.charAt(1));
        }
        return Character.valueOf(text.charAt(0));
    }
}

