/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.VerticalLayout;

public class CollapsibleTreePanel
extends DCPanel {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final JXCollapsiblePane _collapsibleTreePane = new JXCollapsiblePane(JXCollapsiblePane.Direction.LEFT);
    private final JButton _toggleTreeViewButton;

    public CollapsibleTreePanel(JComponent treeComponent) {
        this._collapsibleTreePane.getContentPane().setBackground(WidgetUtils.BG_COLOR_DARK);
        this._collapsibleTreePane.add((Component)treeComponent);
        this._toggleTreeViewButton = new JButton(imageManager.getImageIcon("images/widgets/tree-panel-collapse.png", new ClassLoader[0]));
        this._toggleTreeViewButton.setBorder(null);
        this._toggleTreeViewButton.setOpaque(false);
        this._toggleTreeViewButton.setContentAreaFilled(false);
        this._toggleTreeViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean collapsed = CollapsibleTreePanel.this._collapsibleTreePane.isCollapsed();
                if (collapsed) {
                    CollapsibleTreePanel.this._toggleTreeViewButton.setIcon(imageManager.getImageIcon("images/widgets/tree-panel-collapse.png", new ClassLoader[0]));
                    CollapsibleTreePanel.this._toggleTreeViewButton.setBorder(null);
                } else {
                    CollapsibleTreePanel.this._toggleTreeViewButton.setIcon(imageManager.getImageIcon("images/widgets/tree-panel-expand.png", new ClassLoader[0]));
                    CollapsibleTreePanel.this._toggleTreeViewButton.setBorder(new EmptyBorder(0, 2, 0, 0));
                }
                CollapsibleTreePanel.this._collapsibleTreePane.setCollapsed(!collapsed);
            }
        });
        DCPanel collapseButtonPanel = new DCPanel();
        collapseButtonPanel.setOpaque(true);
        collapseButtonPanel.setBackground(WidgetUtils.BG_COLOR_DARK);
        collapseButtonPanel.setLayout((LayoutManager)new VerticalLayout(4));
        collapseButtonPanel.setBorder(null);
        collapseButtonPanel.add(this._toggleTreeViewButton);
        this.setLayout(new BorderLayout());
        this.add((Component)this._collapsibleTreePane, "Center");
        this.add((Component)collapseButtonPanel, "East");
    }

    public void setCollapsed(boolean collapsed) {
        if (collapsed != this._collapsibleTreePane.isCollapsed()) {
            this._toggleTreeViewButton.doClick();
        }
    }

    public boolean isCollapsed() {
        return this._collapsibleTreePane.isCollapsed();
    }
}

