/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.metamodel.util.Ref;
import org.jdesktop.swingx.JXCollapsiblePane;

public class DCCollapsiblePanel {
    private static final Icon _expandedIcon = ImageManager.getInstance().getImageIcon("images/actions/add.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
    private static final Icon _collapsedIcon = ImageManager.getInstance().getImageIcon("images/actions/remove.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]);
    private final JXCollapsiblePane _collapsiblePane;
    private final DCLabel _label;
    private final Ref<? extends JComponent> _componentRef;
    private String _collapsedText;
    private String _expandedText;
    private boolean _rendered = false;

    public DCCollapsiblePanel() {
        this(null, null, true, null);
    }

    public DCCollapsiblePanel(String collapsedText, String expandedText, boolean collapsed, Ref<? extends JComponent> componentRef) {
        this._collapsedText = collapsedText;
        this._expandedText = expandedText;
        this._collapsiblePane = WidgetFactory.createCollapsiblePane(JXCollapsiblePane.Direction.DOWN);
        this._componentRef = componentRef;
        if (collapsed) {
            this._label = DCLabel.dark(collapsedText);
            this.collapse();
        } else {
            this._label = DCLabel.dark(expandedText);
            this.expand();
        }
        this._label.setFont(WidgetUtils.FONT_HEADER2);
        this._label.setCursor(Cursor.getPredefinedCursor(12));
        this._label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DCCollapsiblePanel.this.toggle();
            }
        });
    }

    public DCPanel toPanel() {
        DCPanel panel = new DCPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this._label, "North");
        panel.add((Component)this._collapsiblePane, "Center");
        return panel;
    }

    public void toggle() {
        if (this.isCollapsed()) {
            this.expand();
        } else {
            this.collapse();
        }
    }

    public void collapse() {
        this.setCollapsed(true);
    }

    public void expand() {
        if (!this._rendered) {
            this._rendered = true;
            this.setComponent((Component)this._componentRef.get());
        }
        this.setCollapsed(false);
    }

    public boolean isCollapsed() {
        return this._collapsiblePane.isCollapsed();
    }

    public void setCollapsed(boolean collapsed) {
        if (collapsed) {
            this._label.setText(this.getCollapsedText());
            this._label.setIcon(_collapsedIcon);
        } else {
            this._label.setText(this.getExpandedText());
            this._label.setIcon(_expandedIcon);
        }
        this._collapsiblePane.setCollapsed(collapsed);
        this._collapsiblePane.updateUI();
    }

    public String getCollapsedText() {
        return this._collapsedText;
    }

    public void setCollapsedText(String collapsedText) {
        this._collapsedText = collapsedText;
    }

    public String getExpandedText() {
        return this._expandedText;
    }

    public void setExpandedText(String expandedText) {
        this._expandedText = expandedText;
    }

    public Component getComponent() {
        Container contentPane = this._collapsiblePane.getContentPane();
        if (contentPane.getComponentCount() == 0) {
            return null;
        }
        DCPanel innerPanel = (DCPanel)contentPane.getComponent(0);
        return innerPanel.getComponent(0);
    }

    public void setComponent(Component component) {
        Container contentPane = this._collapsiblePane.getContentPane();
        contentPane.removeAll();
        if (component != null) {
            contentPane.add(component);
        }
    }
}

