/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class DCComboBox<E>
extends JComboBox
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private final List<Listener<E>> _listeners = new ArrayList<Listener<E>>();

    public DCComboBox() {
        this((ComboBoxModel)new DefaultComboBoxModel());
    }

    public DCComboBox(Collection<E> items) {
        this((ComboBoxModel)new DefaultComboBoxModel<Object>(items.toArray()));
    }

    public DCComboBox(E[] items) {
        this((ComboBoxModel)new DefaultComboBoxModel<E>(items));
    }

    public DCComboBox(ComboBoxModel model) {
        super(model);
        super.addItemListener(this);
    }

    public E getSelectedItem() {
        return (E)super.getSelectedItem();
    }

    @Override
    public void setSelectedItem(Object newItem) {
        E previousItem = this.getSelectedItem();
        if (previousItem == newItem) {
            return;
        }
        Object item = newItem;
        super.setSelectedItem(item);
    }

    public void addListener(Listener<E> listener) {
        this._listeners.add(listener);
    }

    public void removeListener(Listener<E> listener) {
        this._listeners.remove(listener);
    }

    @Override
    @Deprecated
    public void addItemListener(ItemListener aListener) {
        super.addItemListener(aListener);
    }

    @Override
    @Deprecated
    public void addActionListener(ActionListener l) {
        super.addActionListener(l);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int stateChange = e.getStateChange();
        if (stateChange == 1) {
            Object newItem = e.getItem();
            this.notifyListeners(newItem);
        } else if (stateChange == 2 && this.getSelectedItem() == null) {
            this.notifyListeners(null);
        }
    }

    public void notifyListeners() {
        this.notifyListeners(this.getSelectedItem());
    }

    private void notifyListeners(E item) {
        for (Listener<E> listener : this._listeners) {
            listener.onItemSelected(item);
        }
    }

    public static interface Listener<E> {
        public void onItemSelected(E var1);
    }
}

