/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.eobjects.analyzer.util.VFSUtils;
import org.eobjects.datacleaner.util.LookAndFeelManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DefaultFileIconFactory;
import org.eobjects.datacleaner.widgets.FileIconFactory;

public class DCFileChooser
extends JFileChooser {
    private static final long serialVersionUID = 1L;
    private static final FileIconFactory _defaultFileIconFactory = new DefaultFileIconFactory();
    private FileIconFactory _fileIconFactory;

    public DCFileChooser() {
        this((File)null);
    }

    public DCFileChooser(File dir) {
        super(dir);
        this.setPreferredSize(new Dimension(600, 550));
        this.setFilePaneBackground(WidgetUtils.BG_COLOR_BRIGHTEST);
        this.setAcceptAllFileFilterUsed(false);
    }

    public void setFilePaneBackground(Color bg) {
        this.setFilePaneBackground(this, bg);
    }

    private void setFilePaneBackground(Container container, Color bg) {
        Component[] children;
        for (Component component : children = container.getComponents()) {
            if (component instanceof JScrollPane) {
                JScrollPane scroll = (JScrollPane)component;
                this.setContainerBackground(scroll.getComponent(0), bg);
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.setFilePaneBackground((Container)component, bg);
        }
    }

    private void setContainerBackground(Component component, Color bg) {
        Container childContainer;
        Container c;
        Component child;
        if (component instanceof Container && (child = (c = (Container)component).getComponent(0)) instanceof Container && (childContainer = (Container)child).getComponentCount() == 1) {
            this.setContainerBackground(childContainer, bg);
        }
        component.setBackground(bg);
    }

    public FileObject getSelectedFileObject() {
        File selectedFile = this.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        try {
            return VFSUtils.getFileSystemManager().toFileObject(selectedFile);
        }
        catch (FileSystemException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Icon getIcon(File f) {
        return this.getFileIconFactory().getIcon(f);
    }

    public static void main(String[] args) {
        LookAndFeelManager.getInstance().init();
        DCFileChooser fc = new DCFileChooser();
        fc.showOpenDialog(null);
    }

    public FileIconFactory getFileIconFactory() {
        if (this._fileIconFactory == null) {
            return _defaultFileIconFactory;
        }
        return this._fileIconFactory;
    }
}

