/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.eobjects.datacleaner.util.WidgetUtils;

public class DCLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private final boolean _multiline;

    public static DCLabel bright(String text) {
        return new DCLabel(false, text, WidgetUtils.BG_COLOR_BRIGHTEST, null);
    }

    public static DCLabel dark(String text) {
        return new DCLabel(false, text, WidgetUtils.BG_COLOR_DARKEST, null);
    }

    public static DCLabel brightMultiLine(String text) {
        return new DCLabel(true, text, WidgetUtils.BG_COLOR_BRIGHTEST, null);
    }

    public static DCLabel darkMultiLine(String text) {
        return new DCLabel(true, text, WidgetUtils.BG_COLOR_DARKEST, null);
    }

    public DCLabel(boolean multiline, String text, Color textColor, Icon icon) {
        this._multiline = multiline;
        if (text != null) {
            this.setText(text);
        }
        if (textColor != null) {
            this.setForeground(textColor);
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        this.setVerticalAlignment(1);
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        if (this._multiline) {
            if (text.indexOf("</p>") == -1) {
                text = "<p>" + text + "</p>";
            }
            if (text.indexOf("<html>") == -1) {
                text = "<html>" + text + "</html>";
            }
            if (text.indexOf("<br") == -1) {
                text = text.replaceAll("\n", "<br>");
            }
        }
        super.setText(text);
    }

    public void setMaximumWidth(int width) {
        String text = this.getText();
        if (text.startsWith("<html>") && text.endsWith("</html>")) {
            text = text.substring(6, text.length() - 7);
        }
        super.setText("<html><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"" + width + "\"><tr><td>" + text + "</td></tr></table></html>");
    }
}

