/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.awt.Dimension;
import java.util.Map;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.user.UserPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCPersistentSizedPanel
extends DCPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DCPersistentSizedPanel.class);
    private final String _identifier;
    private final int _defaultWidth;
    private final int _defaultHeight;
    private final UserPreferences _userPreferences;

    public DCPersistentSizedPanel(UserPreferences userPreferences, String identifier, int defaultWidth, int defaultHeight) {
        this._identifier = identifier;
        this._defaultWidth = defaultWidth;
        this._defaultHeight = defaultHeight;
        this._userPreferences = userPreferences;
        this.setPreferredSize(this.getPreferredSizeFromUserPreferences());
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Map<String, String> properties = this._userPreferences.getAdditionalProperties();
        Dimension size = this.getSize();
        logger.info("Persisting panel size: {}", (Object)size);
        properties.put(this.getWidthPropertyKey(), "" + size.width);
        properties.put(this.getHeightPropertyKey(), "" + size.height);
    }

    private Dimension getPreferredSizeFromUserPreferences() {
        String heightStr;
        Map<String, String> properties = this._userPreferences.getAdditionalProperties();
        String widthStr = properties.get(this.getWidthPropertyKey());
        if (widthStr == null) {
            widthStr = "" + this._defaultWidth;
        }
        if ((heightStr = properties.get(this.getHeightPropertyKey())) == null) {
            heightStr = "" + this._defaultHeight;
        }
        return new Dimension(Integer.parseInt(widthStr), Integer.parseInt(heightStr));
    }

    private String getHeightPropertyKey() {
        return this.getClass().getName() + "." + this._identifier + ".height";
    }

    private String getWidthPropertyKey() {
        return this.getClass().getName() + "." + this._identifier + ".width";
    }
}

