/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.eobjects.datacleaner.panels.DCGlassPane;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;

public class DCPopupBubble {
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final DCGlassPane _glassPane;
    private final DCPanel _panel;
    private int _xOnScreen;
    private int _yOnScreen;

    public DCPopupBubble(DCGlassPane glassPane, String text, int xOnScreen, int yOnScreen) {
        this(glassPane, text, xOnScreen, yOnScreen, null);
    }

    public DCPopupBubble(DCGlassPane glassPane, String text, int xOnScreen, int yOnScreen, String iconPath) {
        this._glassPane = glassPane;
        this._panel = new DCPanel(imageManager.getImage("images/window/popup-bubble.png", new ClassLoader[0]), 0, 0);
        this._xOnScreen = xOnScreen;
        this._yOnScreen = yOnScreen;
        DCLabel label = DCLabel.bright(text);
        if (iconPath != null) {
            label.setIcon(imageManager.getImageIcon(iconPath, new ClassLoader[0]));
        }
        label.setFont(WidgetUtils.FONT_SMALL);
        label.setSize(240, 60);
        label.setLocation(5, 20);
        label.setVerticalAlignment(0);
        this._panel.setLayout(null);
        this._panel.setSize(250, 81);
        this._panel.add(label);
    }

    private void initLocation() {
        Point locationOnScreen = this._glassPane.getLocationOnScreen();
        int x = this._xOnScreen - locationOnScreen.x - 40;
        if (x < 0) {
            x = 0;
        }
        int y = this._yOnScreen - locationOnScreen.y;
        this._panel.setLocation(x, y);
    }

    public void showTooltip(int timeoutMillis) {
        this.initLocation();
        this._glassPane.showTooltip(this._panel, timeoutMillis);
    }

    public void show() {
        this.initLocation();
        this._glassPane.add(this._panel);
    }

    public void hide() {
        this._glassPane.remove(this._panel);
    }

    public void setLocationOnScreen(int x, int y) {
        this._xOnScreen = x;
        this._yOnScreen = y;
    }

    public void attachTo(final JComponent component) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (component.isEnabled()) {
                    Point locationOnScreen = component.getLocationOnScreen();
                    DCPopupBubble.this.setLocationOnScreen(locationOnScreen.x + 15, locationOnScreen.y + component.getHeight());
                    DCPopupBubble.this.show();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DCPopupBubble.this.hide();
            }
        });
    }
}

