/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.eobjects.datacleaner.util.WidgetUtils;

public class DCProgressBar
extends JProgressBar {
    private static final long serialVersionUID = 1L;

    public DCProgressBar(int min, int max) {
        super(min, max);
        this.setMinimumSize(new Dimension(10, 30));
        this.setMaximumSize(new Dimension(1000, 30));
        this.setOpaque(false);
    }

    public void setValueIfHigherAndSignificant(final int newValue) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int currentValue = DCProgressBar.this.getValue();
                if (newValue > currentValue) {
                    DCProgressBar.this.setValue(newValue);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected int getBarWidth(int value) {
        int minimum = this.getMinimum();
        if (minimum > value) {
            return 0;
        }
        int width = this.getWidth();
        int maximum = this.getMaximum();
        if (value > maximum) {
            return width;
        }
        int adjustedMax = maximum - minimum;
        int adjustedValue = value - minimum;
        double completenessRatio = 1.0 * (double)adjustedValue / (double)adjustedMax;
        int barWidth = (int)((double)width * completenessRatio);
        return barWidth;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int barWidth;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isOpaque()) {
            g.setColor(WidgetUtils.BG_COLOR_DARK);
            g.fillRect(0, 0, width, height);
        }
        if ((barWidth = this.getBarWidth(this.getValue())) > 0) {
            g.setColor(WidgetUtils.BG_COLOR_BLUE_BRIGHT);
            g.fillRect(0, 0, barWidth, height / 2);
            g.setColor(WidgetUtils.slightlyDarker(WidgetUtils.BG_COLOR_BLUE_BRIGHT));
            g.fillRect(0, height / 2, barWidth, height / 2);
            g.setColor(WidgetUtils.slightlyBrighter(WidgetUtils.BG_COLOR_BLUE_BRIGHT));
            g.drawRect(0, 0, barWidth, height);
        }
    }
}

