/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.eobjects.analyzer.job.builder.AnalysisJobBuilder;
import org.eobjects.datacleaner.actions.DisplayOutputWritersAction;
import org.eobjects.datacleaner.actions.NewAnalysisJobActionListener;
import org.eobjects.datacleaner.actions.OpenAnalysisJobActionListener;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.windows.AboutDialog;
import org.eobjects.datacleaner.windows.DCWindow;
import org.eobjects.datacleaner.windows.MonitorConnectionDialog;
import org.eobjects.datacleaner.windows.OptionsDialog;
import org.eobjects.datacleaner.windows.ReferenceDataDialog;
import org.jdesktop.swingx.action.OpenBrowserAction;

@Singleton
public class DCWindowMenuBar
extends JMenuBar {
    private static final long serialVersionUID = 1L;
    private final WindowContext _windowContext;
    private final ActionListener _windowListener;
    private final Provider<ReferenceDataDialog> _referenceDataDialogProvider;
    private final Provider<OptionsDialog> _optionsDialogProvider;
    private final JMenu _writeDataMenu;
    private final Provider<MonitorConnectionDialog> _monitorConnectionDialogProvider;

    @Inject
    protected DCWindowMenuBar(WindowContext windowContext, Provider<ReferenceDataDialog> referenceDataDialogProvider, NewAnalysisJobActionListener newAnalysisJobActionListener, OpenAnalysisJobActionListener openAnalysisJobActionListener, Provider<OptionsDialog> optionsDialogProvider, Provider<MonitorConnectionDialog> monitorConnectionDialogProvider) {
        this._windowContext = windowContext;
        this._referenceDataDialogProvider = referenceDataDialogProvider;
        this._optionsDialogProvider = optionsDialogProvider;
        this._monitorConnectionDialogProvider = monitorConnectionDialogProvider;
        JMenuItem newJobMenuItem = WidgetFactory.createMenuItem("New analysis job", "images/actions/new_analysis_job.png");
        newJobMenuItem.addActionListener(newAnalysisJobActionListener);
        JMenuItem openJobMenuItem = WidgetFactory.createMenuItem("Open analysis job...", "images/actions/open.png");
        openJobMenuItem.addActionListener(openAnalysisJobActionListener);
        JMenuItem exitMenuItem = WidgetFactory.createMenuItem("Exit DataCleaner", "images/menu/exit.png");
        exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DCWindowMenuBar.this._windowContext.showExitDialog()) {
                    DCWindowMenuBar.this._windowContext.exit();
                }
            }
        });
        JMenuItem dictionariesMenuItem = WidgetFactory.createMenuItem("Dictionaries", "images/model/dictionary.png");
        dictionariesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceDataDialog referenceDataDialog = (ReferenceDataDialog)DCWindowMenuBar.this._referenceDataDialogProvider.get();
                referenceDataDialog.selectDictionariesTab();
                referenceDataDialog.open();
            }
        });
        JMenuItem synonymCatalogsMenuItem = WidgetFactory.createMenuItem("Synonyms", "images/model/synonym.png");
        synonymCatalogsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceDataDialog referenceDataDialog = (ReferenceDataDialog)DCWindowMenuBar.this._referenceDataDialogProvider.get();
                referenceDataDialog.selectSynonymsTab();
                referenceDataDialog.open();
            }
        });
        JMenuItem stringPatternsMenuItem = WidgetFactory.createMenuItem("String patterns", "images/model/stringpattern.png");
        stringPatternsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceDataDialog referenceDataDialog = (ReferenceDataDialog)DCWindowMenuBar.this._referenceDataDialogProvider.get();
                referenceDataDialog.selectStringPatternsTab();
                referenceDataDialog.open();
            }
        });
        JMenuItem optionsMenuItem = WidgetFactory.createMenuItem("Options", "images/menu/options.png");
        optionsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDialog optionsDialog = (OptionsDialog)DCWindowMenuBar.this._optionsDialogProvider.get();
                optionsDialog.open();
            }
        });
        JMenuItem dqMonitorMenuItem = WidgetFactory.createMenuItem("DataCleaner dq monitor", "images/menu/dq_monitor.png");
        dqMonitorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitorConnectionDialog dialog = (MonitorConnectionDialog)DCWindowMenuBar.this._monitorConnectionDialogProvider.get();
                dialog.open();
            }
        });
        JMenuItem helpContents = WidgetFactory.createMenuItem("Help contents", "images/widgets/help.png");
        helpContents.addActionListener((ActionListener)new OpenBrowserAction("http://datacleaner.org/docs"));
        JMenuItem askAtTheForumsMenuItem = WidgetFactory.createMenuItem("Ask at the forums", "images/menu/forums.png");
        askAtTheForumsMenuItem.addActionListener((ActionListener)new OpenBrowserAction("http://datacleaner.org/forum/1"));
        JMenuItem aboutMenuItem = WidgetFactory.createMenuItem("About DataCleaner", "images/menu/about.png");
        aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AboutDialog(DCWindowMenuBar.this._windowContext).setVisible(true);
            }
        });
        JMenu fileMenu = WidgetFactory.createMenu("File", 'F');
        fileMenu.add(newJobMenuItem);
        fileMenu.add(openJobMenuItem);
        fileMenu.add(exitMenuItem);
        JMenu referenceDataMenu = WidgetFactory.createMenu("Reference data", 'R');
        referenceDataMenu.add(dictionariesMenuItem);
        referenceDataMenu.add(synonymCatalogsMenuItem);
        referenceDataMenu.add(stringPatternsMenuItem);
        this._writeDataMenu = WidgetFactory.createMenu("Write data", 'W');
        final JMenu windowMenu = WidgetFactory.createMenu("Window", 'W');
        windowMenu.add(optionsMenuItem);
        windowMenu.add(dqMonitorMenuItem);
        windowMenu.addSeparator();
        final int minimumSize = windowMenu.getMenuComponentCount();
        this._windowListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int currentSize;
                for (int i = currentSize = windowMenu.getMenuComponentCount(); i > minimumSize; --i) {
                    windowMenu.remove(i - 1);
                }
                List<DCWindow> windows = DCWindowMenuBar.this._windowContext.getWindows();
                for (final DCWindow window : windows) {
                    Image windowIcon = window.getWindowIcon();
                    String title = window.getWindowTitle();
                    ImageIcon icon = new ImageIcon(windowIcon.getScaledInstance(32, 32, 1));
                    JMenuItem switchToWindowItem = WidgetFactory.createMenuItem(title, icon);
                    switchToWindowItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            window.toFront();
                        }
                    });
                    windowMenu.add(switchToWindowItem);
                }
            }
        };
        JMenu helpMenu = WidgetFactory.createMenu("Help", 'H');
        helpMenu.add(askAtTheForumsMenuItem);
        helpMenu.add(helpContents);
        helpMenu.add(aboutMenuItem);
        this.add(fileMenu);
        this.add(referenceDataMenu);
        this.add(this._writeDataMenu);
        this.add(windowMenu);
        this.add(helpMenu);
    }

    public JMenu getWriteDataMenu() {
        return this._writeDataMenu;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._windowContext.addWindowListener(this._windowListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._windowContext.removeWindowListener(this._windowListener);
    }

    public void setAnalysisJobBuilder(AnalysisJobBuilder analysisJobBuilder) {
        List<JMenuItem> menuItems = new DisplayOutputWritersAction(analysisJobBuilder).createMenuItems();
        this._writeDataMenu.removeAll();
        for (JMenuItem menuItem : menuItems) {
            this._writeDataMenu.add(menuItem);
        }
    }
}

