/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.eobjects.datacleaner.util.FileFilters;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.widgets.FileIconFactory;

public class DefaultFileIconFactory
implements FileIconFactory {
    private static final ImageManager imageManager = ImageManager.getInstance();
    private static final ImageIcon ICON_FILE_CSV = imageManager.getImageIcon("images/datastore-types/csv.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]);
    private static final ImageIcon ICON_FILE_ACCESS = imageManager.getImageIcon("images/datastore-types/access.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]);
    private static final ImageIcon ICON_FILE_DBASE = imageManager.getImageIcon("images/datastore-types/dbase.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]);
    private static final ImageIcon ICON_FILE_EXCEL = imageManager.getImageIcon("images/datastore-types/excel.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]);
    private static final ImageIcon ICON_FILE_ODB = imageManager.getImageIcon("images/datastore-types/odb.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]);
    private static final ImageIcon ICON_FILE_ANALYSIS_JOB = imageManager.getImageIcon("images/filetypes/analysis_job.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]);
    private static final ImageIcon ICON_FILE_ANALYSIS_RESULT = imageManager.getImageIcon("images/filetypes/analysis_result.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]);
    private static final ImageIcon ICON_FILE_XML = imageManager.getImageIcon("images/datastore-types/xml.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]);
    private static final ImageIcon ICON_FILE = imageManager.getImageIcon("images/filetypes/file.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]);
    private static final ImageIcon ICON_FILE_ARCHIVE = imageManager.getImageIcon("images/filetypes/archive.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]);
    private static final ImageIcon ICON_FOLDER = imageManager.getImageIcon("images/filetypes/folder.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]);
    private static final ImageIcon ICON_FOLDER_HIDDEN = imageManager.getImageIcon("images/filetypes/hidden-folder.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]);
    private static final ImageIcon ICON_FOLDER_DESKTOP = imageManager.getImageIcon("images/filetypes/desktop-folder.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]);
    private static final ImageIcon ICON_FOLDER_HOME = imageManager.getImageIcon("images/filetypes/home-folder.png", IconUtils.ICON_SIZE_MEDIUM, new ClassLoader[0]);
    private static final String USER_HOME_PATH = System.getProperty("user.home");
    private static final String DESKTOP_PATH = USER_HOME_PATH + File.separatorChar + "Desktop";

    @Override
    public Icon getIcon(File f) {
        String name = f.getName().toLowerCase();
        if (f.isDirectory()) {
            String absolutePath = f.getAbsolutePath();
            if (USER_HOME_PATH.equals(absolutePath)) {
                return ICON_FOLDER_HOME;
            }
            if (DESKTOP_PATH.equals(absolutePath)) {
                return ICON_FOLDER_DESKTOP;
            }
            if (name.startsWith(".") || f.isHidden()) {
                return ICON_FOLDER_HIDDEN;
            }
            return ICON_FOLDER;
        }
        if (name.endsWith(FileFilters.ANALYSIS_XML.getExtension())) {
            return ICON_FILE_ANALYSIS_JOB;
        }
        if (name.endsWith(FileFilters.ANALYSIS_RESULT_SER.getExtension())) {
            return ICON_FILE_ANALYSIS_RESULT;
        }
        if (name.endsWith(FileFilters.ODB.getExtension())) {
            return ICON_FILE_ODB;
        }
        if (name.endsWith(FileFilters.XML.getExtension())) {
            return ICON_FILE_XML;
        }
        if (name.endsWith(FileFilters.DBF.getExtension())) {
            return ICON_FILE_DBASE;
        }
        if (name.endsWith(FileFilters.CSV.getExtension()) || name.endsWith(FileFilters.TSV.getExtension()) || name.endsWith(FileFilters.DAT.getExtension()) || name.endsWith(FileFilters.TXT.getExtension())) {
            return ICON_FILE_CSV;
        }
        if (name.endsWith(FileFilters.MDB.getExtension()) || name.endsWith(FileFilters.ACCDB.getExtension())) {
            return ICON_FILE_ACCESS;
        }
        if (name.endsWith(FileFilters.XLS.getExtension()) || name.endsWith(FileFilters.XLSX.getExtension())) {
            return ICON_FILE_EXCEL;
        }
        if (name.endsWith(".zip") || name.endsWith(".tar") || name.endsWith(".gz") || name.endsWith(".jar") || name.endsWith(".war") || name.endsWith(".ear")) {
            return ICON_FILE_ARCHIVE;
        }
        return ICON_FILE;
    }
}

