/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.eobjects.analyzer.beans.api.ComponentCategory;
import org.eobjects.analyzer.beans.writers.WriteDataCategory;
import org.eobjects.analyzer.descriptors.BeanDescriptor;
import org.eobjects.analyzer.util.CollectionUtils2;
import org.eobjects.datacleaner.util.DisplayNameComparator;
import org.eobjects.datacleaner.widgets.DescriptorMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DescriptorPopupMenu<E extends BeanDescriptor<?>>
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DescriptorPopupMenu.class);
    private final List<? extends E> _descriptors;

    public DescriptorPopupMenu(Collection<? extends E> descriptors) {
        this._descriptors = CollectionUtils2.sorted(descriptors, (Comparator)new DisplayNameComparator());
        this.initialize();
    }

    private void initialize() {
        HashMap<ComponentCategory, DescriptorMenu> descriptorMenus = new HashMap<ComponentCategory, DescriptorMenu>();
        for (BeanDescriptor descriptor : this._descriptors) {
            Set componentCategories = descriptor.getComponentCategories();
            for (ComponentCategory componentCategory : componentCategories) {
                DescriptorMenu menu = (DescriptorMenu)descriptorMenus.get(componentCategory);
                if (menu == null) {
                    menu = new DescriptorMenu(componentCategory);
                    descriptorMenus.put(componentCategory, menu);
                }
                menu.addComponentClass(descriptor.getComponentClass());
            }
        }
        List sortedMenus = CollectionUtils2.sorted(descriptorMenus.values());
        for (DescriptorMenu descriptorMenu : sortedMenus) {
            int count = descriptorMenu.getComponentClassCount();
            if (count <= 1) {
                ComponentCategory category = descriptorMenu.getComponentCategory();
                logger.info("Disregarding menu for category '{}' because of too few components ({})", (Object)category, (Object)count);
                descriptorMenus.remove(category);
                continue;
            }
            this.add(descriptorMenu);
        }
        for (BeanDescriptor descriptor : this._descriptors) {
            boolean placedInSubmenu = false;
            Class componentClass = descriptor.getComponentClass();
            JMenuItem menuItem = this.createMenuItem(descriptor);
            if (menuItem == null) continue;
            for (DescriptorMenu descriptorMenu : descriptorMenus.values()) {
                if (!descriptorMenu.containsComponentClass(componentClass)) continue;
                descriptorMenu.add(menuItem);
                placedInSubmenu = true;
                menuItem = this.createMenuItem(descriptor);
            }
            if (placedInSubmenu) continue;
            this.add(menuItem);
        }
        DescriptorMenu writeDataMenu = (DescriptorMenu)descriptorMenus.get(new WriteDataCategory());
        if (writeDataMenu != null) {
            this.remove(writeDataMenu);
        }
    }

    protected abstract JMenuItem createMenuItem(E var1);
}

