/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.filechooser.FileFilter;
import org.eobjects.analyzer.util.StringUtils;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetFactory;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCFileChooser;
import org.eobjects.datacleaner.widgets.FileSelectionListener;
import org.jdesktop.swingx.JXTextField;

public final class FilenameTextField
extends DCPanel {
    private static final long serialVersionUID = 1L;
    private final JXTextField _textField = WidgetFactory.createTextField("Filename");
    private final JButton _browseButton = WidgetFactory.createButton("Browse", ImageManager.getInstance().getImageIcon("images/actions/browse.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
    private final List<FileSelectionListener> _listeners = new ArrayList<FileSelectionListener>();
    private final List<FileFilter> _chooseableFileFilters = new ArrayList<FileFilter>();
    private volatile FileFilter _selectedFileFilter;
    private volatile File _directory;
    private int _fileSelectionMode = 0;

    public FilenameTextField(File directory, final boolean fileOpenDialog) {
        this._directory = directory;
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add((Component)this._textField);
        this.add(Box.createHorizontalStrut(4));
        this.add(this._browseButton);
        this._browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result;
                DCFileChooser fileChooser = FilenameTextField.this._directory == null ? new DCFileChooser() : new DCFileChooser(FilenameTextField.this._directory);
                WidgetUtils.centerOnScreen(fileChooser);
                for (FileFilter filter : FilenameTextField.this._chooseableFileFilters) {
                    fileChooser.addChoosableFileFilter(filter);
                }
                fileChooser.setFileSelectionMode(FilenameTextField.this._fileSelectionMode);
                if (FilenameTextField.this._selectedFileFilter != null) {
                    if (!FilenameTextField.this._chooseableFileFilters.contains(FilenameTextField.this._selectedFileFilter)) {
                        FilenameTextField.this._chooseableFileFilters.add(FilenameTextField.this._selectedFileFilter);
                    }
                    fileChooser.setFileFilter(FilenameTextField.this._selectedFileFilter);
                }
                if ((result = fileOpenDialog ? fileChooser.showOpenDialog(FilenameTextField.this) : fileChooser.showSaveDialog(FilenameTextField.this)) == 0) {
                    File file = fileChooser.getSelectedFile();
                    boolean accepted = true;
                    if (fileOpenDialog) {
                        accepted = file.exists();
                    }
                    if (accepted) {
                        FilenameTextField.this.setFile(file);
                        if (file.isDirectory()) {
                            FilenameTextField.this._directory = file;
                        } else {
                            FilenameTextField.this._directory = file.getParentFile();
                        }
                        for (FileSelectionListener listener : FilenameTextField.this._listeners) {
                            listener.onSelected(FilenameTextField.this, file);
                        }
                    }
                }
            }
        });
    }

    public File getDirectory() {
        return this._directory;
    }

    public JButton getBrowseButton() {
        return this._browseButton;
    }

    public JXTextField getTextField() {
        return this._textField;
    }

    public String getFilename() {
        return this._textField.getText();
    }

    public void setFilename(String filename) {
        this._textField.setText(filename);
    }

    public void setFile(File file) {
        try {
            this.setFilename(file.getCanonicalPath());
        }
        catch (IOException e1) {
            this.setFilename(file.getAbsolutePath());
        }
    }

    public File getFile() {
        String filename = this.getFilename();
        if (StringUtils.isNullOrEmpty((String)filename)) {
            return null;
        }
        return new File(filename);
    }

    public void addFileSelectionListener(FileSelectionListener listener) {
        this._listeners.add(listener);
    }

    public void removeFileSelectionListener(FileSelectionListener listener) {
        this._listeners.remove(listener);
    }

    public void addChoosableFileFilter(FileFilter filter) {
        this._chooseableFileFilters.add(filter);
    }

    public void setSelectedFileFilter(FileFilter filter) {
        this._selectedFileFilter = filter;
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        this._fileSelectionMode = fileSelectionMode;
    }

    public int getFileSelectionMode() {
        return this._fileSelectionMode;
    }
}

