/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.border.CompoundBorder;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.widgets.tooltip.DCToolTip;

public final class HelpIcon
extends JLabel {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private final String _helpMessage;
    private final Icon _tooltipIcon;

    public HelpIcon(String helpMessage, Icon tooltipIcon) {
        super(imageManager.getImageIcon("images/widgets/help.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
        this._tooltipIcon = tooltipIcon;
        this._helpMessage = helpMessage;
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public HelpIcon(String helpMessage) {
        this(helpMessage, imageManager.getImageIcon("images/widgets/help.png", new ClassLoader[0]));
    }

    @Override
    public String getToolTipText() {
        return this._helpMessage;
    }

    @Override
    public JToolTip createToolTip() {
        DCPanel panel = new DCPanel();
        panel.setOpaque(true);
        panel.setBackground(WidgetUtils.BG_COLOR_DARK);
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JLabel(this._tooltipIcon), "West");
        DCLabel descriptionLabel = DCLabel.brightMultiLine(this._helpMessage);
        panel.add((Component)descriptionLabel, "Center");
        CompoundBorder border = new CompoundBorder(WidgetUtils.BORDER_THIN, WidgetUtils.BORDER_EMPTY);
        panel.setBorder(border);
        panel.setPreferredSize(300, 130);
        return new DCToolTip(this, panel);
    }
}

