/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.eobjects.datacleaner.actions.LoginChangeListener;
import org.eobjects.datacleaner.panels.DCGlassPane;
import org.eobjects.datacleaner.panels.LoginPanel;
import org.eobjects.datacleaner.user.AuthenticationService;
import org.eobjects.datacleaner.user.UserPreferences;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.windows.OptionsDialog;

public class LoginStatusLabel
extends JLabel
implements LoginChangeListener {
    private static final long serialVersionUID = 1L;
    private static final ImageIcon ONLINE_ICON = ImageManager.getInstance().getImageIcon("images/status/trafficlight-green.png", new ClassLoader[0]);
    private static final ImageIcon OFFLINE_ICON = ImageManager.getInstance().getImageIcon("images/status/trafficlight-red.png", new ClassLoader[0]);
    private final UserPreferences _userPreferences;
    private final DCGlassPane _glassPane;
    private final LoginPanel _loginPanel;
    private final Provider<OptionsDialog> _optionsDialogProvider;

    @Inject
    protected LoginStatusLabel(DCGlassPane glassPane, UserPreferences userPreferences, Provider<OptionsDialog> optionsDialogProvider, AuthenticationService authenticationService) {
        this._glassPane = glassPane;
        this._userPreferences = userPreferences;
        this._loginPanel = new LoginPanel(authenticationService, this._glassPane, userPreferences);
        this._userPreferences.addLoginChangeListener(this);
        this._optionsDialogProvider = optionsDialogProvider;
        this.setForeground(WidgetUtils.BG_COLOR_BRIGHTEST);
        boolean loggedIn = this._userPreferences.isLoggedIn();
        String username = this._userPreferences.getUsername();
        this.onLoginStateChanged(loggedIn, username);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LoginStatusLabel.this.onMouseClick();
            }
        });
    }

    private void onMouseClick() {
        if (this._userPreferences.isLoggedIn()) {
            OptionsDialog optionsDialog = (OptionsDialog)this._optionsDialogProvider.get();
            optionsDialog.setVisible(true);
        } else if (this._loginPanel.isVisible()) {
            this._loginPanel.moveOut(0);
        } else {
            this._loginPanel.moveIn(0);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._userPreferences.removeLoginChangeListener(this);
    }

    @Override
    public void onLoginStateChanged(boolean loggedIn, String username) {
        if (loggedIn) {
            this.setIcon(ONLINE_ICON);
            this.setText("Online: " + username);
            this.setToolTipText(null);
        } else {
            this.setIcon(OFFLINE_ICON);
            this.setText("Offline");
            this.setToolTipText("<html>Log in to gain access<br/>to online content through<br/>the RegexSwap and more.</html>");
        }
    }
}

