/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import com.google.inject.Injector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.inject.Provider;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.apache.commons.vfs2.FileObject;
import org.eobjects.analyzer.configuration.AnalyzerBeansConfiguration;
import org.eobjects.analyzer.connection.Datastore;
import org.eobjects.analyzer.job.AnalysisJobMetadata;
import org.eobjects.analyzer.job.JaxbJobReader;
import org.eobjects.datacleaner.actions.OpenAnalysisJobActionListener;
import org.eobjects.datacleaner.bootstrap.WindowContext;
import org.eobjects.datacleaner.panels.DCPanel;
import org.eobjects.datacleaner.util.FileFilters;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.util.WidgetUtils;
import org.eobjects.datacleaner.widgets.DCFileChooser;
import org.eobjects.datacleaner.widgets.DCLabel;
import org.eobjects.datacleaner.windows.AnalysisJobBuilderWindow;
import org.eobjects.datacleaner.windows.OpenAnalysisJobAsTemplateDialog;
import org.jdesktop.swingx.VerticalLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAnalysisJobFileChooserAccessory
extends DCPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(OpenAnalysisJobFileChooserAccessory.class);
    private static final ImageManager imageManager = ImageManager.getInstance();
    private static final ImageIcon ICON_APP = ImageManager.getInstance().getImageIcon("images/window/app-icon.png", new ClassLoader[0]);
    private static final int WIDTH = 220;
    private final AnalyzerBeansConfiguration _configuration;
    private final DCFileChooser _fileChooser;
    private final DCPanel _centerPanel;
    private final JButton _openJobButton;
    private final WindowContext _windowContext;
    private final Provider<OpenAnalysisJobActionListener> _openAnalysisJobActionListenerProvider;
    private volatile FileObject _file;
    private volatile AnalysisJobMetadata _metadata;

    public OpenAnalysisJobFileChooserAccessory(WindowContext windowContext, AnalyzerBeansConfiguration configuration, DCFileChooser fileChooser, Provider<OpenAnalysisJobActionListener> openAnalysisJobActionListenerProvider) {
        this._windowContext = windowContext;
        this._configuration = configuration;
        this._centerPanel = new DCPanel();
        this._centerPanel.setLayout((LayoutManager)new VerticalLayout(0));
        this._fileChooser = fileChooser;
        this._fileChooser.addPropertyChangeListener(this);
        this._openJobButton = this.getOpenJobButton();
        this._openAnalysisJobActionListenerProvider = openAnalysisJobActionListenerProvider;
        this.setPreferredSize(220, 10);
        this.setBorder(new EmptyBorder(0, 10, 0, 0));
        this.setLayout(new BorderLayout());
        this.setVisible(false);
        JLabel iconLabel = new JLabel(ICON_APP);
        JLabel headerLabel = new JLabel("DataCleaner analysis job:");
        headerLabel.setFont(WidgetUtils.FONT_HEADER1);
        DCPanel northPanel = new DCPanel();
        northPanel.setLayout((LayoutManager)new VerticalLayout(0));
        northPanel.add(iconLabel);
        northPanel.add(Box.createVerticalStrut(10));
        northPanel.add(headerLabel);
        northPanel.add(Box.createVerticalStrut(10));
        northPanel.add(this._centerPanel);
        northPanel.add(Box.createVerticalStrut(10));
        DCPanel southPanel = new DCPanel();
        southPanel.setLayout((LayoutManager)new VerticalLayout(0));
        northPanel.add(Box.createVerticalStrut(4));
        southPanel.add(this._openJobButton);
        southPanel.add(Box.createVerticalStrut(4));
        southPanel.add(this.getOpenAsTemplateButton());
        this.add((Component)WidgetUtils.scrolleable(northPanel), "Center");
        this.add((Component)southPanel, "South");
    }

    private JButton getOpenJobButton() {
        JButton openJobButton = new JButton("Open analysis job");
        openJobButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenAnalysisJobActionListener openAnalysisJobActionListener = (OpenAnalysisJobActionListener)OpenAnalysisJobFileChooserAccessory.this._openAnalysisJobActionListenerProvider.get();
                Injector injector = openAnalysisJobActionListener.openAnalysisJob(OpenAnalysisJobFileChooserAccessory.this._file);
                AnalysisJobBuilderWindow window = (AnalysisJobBuilderWindow)injector.getInstance(AnalysisJobBuilderWindow.class);
                window.open();
                OpenAnalysisJobFileChooserAccessory.this._fileChooser.cancelSelection();
            }
        });
        return openJobButton;
    }

    private JButton getOpenAsTemplateButton() {
        JButton openAsTemplateButton = new JButton("Open as template");
        openAsTemplateButton.setToolTipText("Allows you to open the job with a different datastore and different source columns.");
        openAsTemplateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OpenAnalysisJobAsTemplateDialog dialog = new OpenAnalysisJobAsTemplateDialog(OpenAnalysisJobFileChooserAccessory.this._windowContext, OpenAnalysisJobFileChooserAccessory.this._configuration, OpenAnalysisJobFileChooserAccessory.this._file, OpenAnalysisJobFileChooserAccessory.this._metadata, (Provider<OpenAnalysisJobActionListener>)OpenAnalysisJobFileChooserAccessory.this._openAnalysisJobActionListenerProvider);
                OpenAnalysisJobFileChooserAccessory.this._fileChooser.cancelSelection();
                dialog.setVisible(true);
            }
        });
        return openAsTemplateButton;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("SelectedFileChangedProperty".equals(evt.getPropertyName())) {
            this._file = this._fileChooser.getSelectedFileObject();
            if (this._file != null && this._file.getName().getBaseName().endsWith(FileFilters.ANALYSIS_XML.getExtension())) {
                this.showFileInformation();
            } else {
                this.setVisible(false);
            }
        }
    }

    private void showFileInformation() {
        Date updatedDate;
        Date createdDate;
        String author;
        String jobVersion;
        String jobDescription;
        JaxbJobReader reader = new JaxbJobReader(this._configuration);
        try {
            this._metadata = reader.readMetadata(this._file);
        }
        catch (Exception e) {
            logger.warn("An unexpected error occurred reading metadata from file", (Throwable)e);
            this.setVisible(false);
            return;
        }
        this._centerPanel.removeAll();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        int separatorHeight = 6;
        String jobName = this._metadata.getJobName();
        if (jobName != null) {
            this._centerPanel.add(new JLabel("<html><b>Job name:</b></html>"));
            this._centerPanel.add(new JLabel(jobName));
            this._centerPanel.add(Box.createVerticalStrut(6));
        }
        if ((jobDescription = this._metadata.getJobDescription()) != null) {
            this._centerPanel.add(new JLabel("<html><b>Job description:</b></html>"));
            DCLabel descriptionLabel = DCLabel.darkMultiLine(jobDescription);
            descriptionLabel.setMaximumWidth(220);
            this._centerPanel.add(descriptionLabel);
            this._centerPanel.add(Box.createVerticalStrut(6));
        }
        if ((jobVersion = this._metadata.getJobVersion()) != null) {
            this._centerPanel.add(new JLabel("<html><b>Job version:</b></html>"));
            this._centerPanel.add(new JLabel(jobVersion));
            this._centerPanel.add(Box.createVerticalStrut(6));
        }
        if ((author = this._metadata.getAuthor()) != null) {
            this._centerPanel.add(new JLabel("<html><b>Author:</b></html>"));
            this._centerPanel.add(new JLabel(author));
            this._centerPanel.add(Box.createVerticalStrut(6));
        }
        if ((createdDate = this._metadata.getCreatedDate()) != null) {
            this._centerPanel.add(new JLabel("<html><b>Created:</b></html>"));
            this._centerPanel.add(new JLabel(dateFormat.format(createdDate)));
            this._centerPanel.add(Box.createVerticalStrut(6));
        }
        if ((updatedDate = this._metadata.getUpdatedDate()) != null) {
            this._centerPanel.add(new JLabel("<html><b>Updated:</b></html>"));
            this._centerPanel.add(new JLabel(dateFormat.format(updatedDate)));
            this._centerPanel.add(Box.createVerticalStrut(6));
        }
        String datastoreName = this._metadata.getDatastoreName();
        this._centerPanel.add(new JLabel("<html><b>Datastore:</b></html>"));
        JLabel datastoreLabel = new JLabel(datastoreName);
        Datastore datastore = this._configuration.getDatastoreCatalog().getDatastore(datastoreName);
        if (datastore == null) {
            this._openJobButton.setEnabled(false);
            datastoreLabel.setIcon(imageManager.getImageIcon("images/status/warning.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
            datastoreLabel.setToolTipText("No such datastore: " + datastoreName);
        } else {
            this._openJobButton.setEnabled(true);
            datastoreLabel.setIcon(IconUtils.getDatastoreIcon(datastore, IconUtils.ICON_SIZE_SMALL));
            datastoreLabel.setToolTipText(null);
        }
        this._centerPanel.add(datastoreLabel);
        this._centerPanel.add(Box.createVerticalStrut(6));
        this._centerPanel.add(new JLabel("<html><b>Source columns:</b></html>"));
        List paths = this._metadata.getSourceColumnPaths();
        for (String path : paths) {
            JLabel columnLabel = new JLabel(path);
            columnLabel.setIcon(imageManager.getImageIcon("images/model/column.png", IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
            this._centerPanel.add(columnLabel);
        }
        this._centerPanel.updateUI();
        this.setVisible(true);
    }
}

