/*
 * Decompiled with CFR 0.152.
 */
package org.eobjects.datacleaner.widgets;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import org.eobjects.analyzer.reference.DatastoreDictionary;
import org.eobjects.analyzer.reference.DatastoreSynonymCatalog;
import org.eobjects.analyzer.reference.Dictionary;
import org.eobjects.analyzer.reference.ReferenceData;
import org.eobjects.analyzer.reference.RegexStringPattern;
import org.eobjects.analyzer.reference.SimpleDictionary;
import org.eobjects.analyzer.reference.SimpleStringPattern;
import org.eobjects.analyzer.reference.StringPattern;
import org.eobjects.analyzer.reference.SynonymCatalog;
import org.eobjects.analyzer.reference.TextFileDictionary;
import org.eobjects.analyzer.reference.TextFileSynonymCatalog;
import org.eobjects.datacleaner.regexswap.RegexSwapStringPattern;
import org.eobjects.datacleaner.util.IconUtils;
import org.eobjects.datacleaner.util.ImageManager;
import org.eobjects.datacleaner.widgets.DCListCellRenderer;

public class ReferenceDataComboBoxListRenderer
extends DCListCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final ImageManager imageManager = ImageManager.getInstance();
    private String nullText = "- none -";

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel result = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value == null) {
            result.setText(this.getNullText());
        } else if (value instanceof ReferenceData) {
            result.setText(((ReferenceData)value).getName());
            String iconPath = null;
            if (value instanceof Dictionary) {
                iconPath = "images/model/dictionary.png";
                if (value instanceof SimpleDictionary) {
                    iconPath = "images/model/dictionary_simple.png";
                } else if (value instanceof TextFileDictionary) {
                    iconPath = "images/model/dictionary_textfile.png";
                } else if (value instanceof DatastoreDictionary) {
                    iconPath = "images/model/dictionary_datastore.png";
                }
            } else if (value instanceof SynonymCatalog) {
                iconPath = "images/model/synonym.png";
                if (value instanceof TextFileSynonymCatalog) {
                    iconPath = "images/model/synonym_textfile.png";
                } else if (value instanceof DatastoreSynonymCatalog) {
                    iconPath = "images/model/synonym_datastore.png";
                }
            } else if (value instanceof StringPattern) {
                iconPath = "images/model/stringpattern.png";
                if (value instanceof SimpleStringPattern) {
                    iconPath = "images/model/stringpattern_simple.png";
                } else if (value instanceof RegexStringPattern) {
                    iconPath = "images/model/stringpattern_regex.png";
                } else if (value instanceof RegexSwapStringPattern) {
                    iconPath = "images/model/stringpattern_regexswap.png";
                }
            }
            if (iconPath != null) {
                result.setIcon(imageManager.getImageIcon(iconPath, IconUtils.ICON_SIZE_SMALL, new ClassLoader[0]));
            }
        }
        return result;
    }

    public void setNullText(String nullText) {
        this.nullText = nullText;
    }

    public String getNullText() {
        return this.nullText;
    }
}

